/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.X500Name;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509.X509CRLEntry;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TbsCertList {
    protected Asn1 asn1 = null;
    protected int version = 1;
    protected AlgorithmId sigAlgo;
    protected X500Name issuer;
    protected UTCTime thisUpdate;
    protected UTCTime nextUpdate;
    protected Set revCerts;
    protected Extensions extns;

    public TbsCertList() {
    }

    public TbsCertList(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        if (!(asn1 instanceof Sequence)) {
            throw new Asn1Exception("Bad CRL encoding");
        }
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        try {
            this.version = ((Integer)asn12).getInt();
            asn12 = (Asn1)iterator.next();
        }
        catch (ClassCastException classCastException) {}
        this.sigAlgo = new AlgorithmId(asn12);
        this.issuer = new X500Name((Asn1)iterator.next());
        this.thisUpdate = (UTCTime)iterator.next();
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        try {
            this.nextUpdate = (UTCTime)asn12;
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        catch (ClassCastException classCastException) {}
        Sequence sequence = (Sequence)asn12;
        this.revCerts = new HashSet();
        Iterator iterator2 = sequence.components();
        while (iterator2.hasNext()) {
            this.revCerts.add(new X509CRLEntry((Asn1)iterator2.next()));
        }
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 0) {
            this.extns = new Extensions((Asn1)asn12.components().next());
        }
    }

    protected AlgorithmId getAlgorithmId() {
        return this.sigAlgo;
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    protected Extensions getExtensions() {
        return this.extns;
    }

    protected X500Name getIssuer() {
        return this.issuer;
    }

    protected UTCTime getNextUpdate() {
        return this.nextUpdate;
    }

    protected Set getRevokedCerts() {
        return this.revCerts;
    }

    protected UTCTime getThisUpdate() {
        return this.thisUpdate;
    }

    protected int getVersion() {
        return this.version;
    }
}

