/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class Validity {
    private Asn1 asn1 = null;
    private Date notBefore;
    private Date notAfter;

    public Validity(int n) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date date = calendar.getTime();
        calendar.add(5, n);
        this.encode(date, calendar.getTime());
    }

    public Validity(Asn1 asn1) {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.notBefore = ((UTCTime)iterator.next()).getDate();
        this.notAfter = ((UTCTime)iterator.next()).getDate();
    }

    public Validity(InputStream inputStream) throws IOException {
        this(Asn1.getAsn1(inputStream));
    }

    public Validity(Date date, Date date2) {
        this.encode(date, date2);
    }

    void encode(Date date, Date date2) {
        this.asn1 = new Sequence();
        this.notBefore = date;
        this.asn1.add(new UTCTime(date));
        this.notAfter = date2;
        this.asn1.add(new UTCTime(date2));
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Not Before: ");
        stringBuffer.append(this.notBefore.toString());
        stringBuffer.append("\nNot After: ");
        stringBuffer.append(this.notAfter.toString());
        return stringBuffer.toString();
    }
}

