/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.common.RDN;
import com.dstc.security.x509.GeneralNames;
import java.util.Iterator;

public class DistributionPoint {
    private Asn1 asn1 = null;
    public static final short UNUSED = Short.MIN_VALUE;
    public static final short KEY_COMPROMISE = 16384;
    public static final short CA_COMPROMISE = 8192;
    public static final short AFFILIATION_CHANGED = 4096;
    public static final short SUPERSEDED = 2048;
    public static final short CESSATION_OF_OPERATION = 1024;
    public static final short CERTIFICATE_HOLD = 512;
    private static final int DISTRIBUTION_POINT_NAME_TAG = 0;
    private static final int REASON_FLAGS_TAG = 1;
    private static final int CRL_ISSUER_TAG = 2;
    private static final int FULL_NAME_TAG = 0;
    private static final int NAME_REL_TO_CRL_ISSUER_TAG = 1;
    private GeneralNames fullName = null;
    private RDN nameRelativeToCRLIssuer = null;
    private short reasonFlags = 0;
    private GeneralNames cRLIssuer = null;

    public DistributionPoint(Asn1 asn1) throws Asn1Exception {
        Object object;
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        if (!iterator.hasNext()) {
            return;
        }
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 0) {
            object = asn12.components();
            if (!object.hasNext()) {
                throw new Asn1Exception("Unknown DistributionPointName data structure");
            }
            Asn1 asn13 = (Asn1)object.next();
            if (asn13.getTagNumber() == 0) {
                this.fullName = new GeneralNames(asn13);
            } else if (asn13.getTagNumber() == 1) {
                this.nameRelativeToCRLIssuer = new RDN(asn13);
            } else {
                throw new Asn1Exception("Unknown DistributionPointName data structure");
            }
            if (object.hasNext()) {
                throw new Asn1Exception("Unknown DistributionPointName data structure");
            }
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 1) {
            asn12.setTagClass(0);
            asn12.setTagNumber(3);
            asn12.getEncoded();
            object = ((BitString)Asn1.getAsn1(asn12.getEncoded())).getBytes();
            this.reasonFlags = (short)(object[0] << 8 & 0xFFFF);
            if (((Object)object).length == 2) {
                this.reasonFlags = (short)(this.reasonFlags | (short)(object[1] & 0xFFFF));
            }
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 2) {
            this.cRLIssuer = new GeneralNames(asn12);
        }
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        throw new Asn1Exception("Unknown DistributionPoint data structure");
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public GeneralNames getCRLIssuer() {
        return this.cRLIssuer;
    }

    public GeneralNames getDistributionPointName() {
        return this.fullName;
    }

    public short getReasonFlags() {
        return this.reasonFlags;
    }

    public RDN getRelativeNameToCRLIssuser() {
        return this.nameRelativeToCRLIssuer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fullName != null) {
            stringBuffer.append("\n    Full Name: " + this.fullName.toString() + "\n");
        } else if (this.nameRelativeToCRLIssuer != null) {
            stringBuffer.append("\n    Name relative to CRL Issuer: " + this.nameRelativeToCRLIssuer.toString() + "\n");
        }
        if (this.reasonFlags != 0) {
            stringBuffer.append("     Reason Flags: \n");
            if ((this.reasonFlags & Short.MIN_VALUE) != 0) {
                stringBuffer.append("        Unused\n");
            }
            if ((this.reasonFlags & 0x4000) != 0) {
                stringBuffer.append("        Key Compromise\n");
            }
            if ((this.reasonFlags & 0x2000) != 0) {
                stringBuffer.append("        CA Compromise\n");
            }
            if ((this.reasonFlags & 0x1000) != 0) {
                stringBuffer.append("        Affiliation Changed\n");
            }
            if ((this.reasonFlags & 0x800) != 0) {
                stringBuffer.append("        SuperSeded\n");
            }
            if ((this.reasonFlags & 0x400) != 0) {
                stringBuffer.append("        Cessation of Operation\n");
            }
            if ((this.reasonFlags & 0x200) != 0) {
                stringBuffer.append("         Certificate Hold\n");
            }
        }
        if (this.cRLIssuer != null) {
            stringBuffer.append("    CRL Issuer: " + this.cRLIssuer.toString());
        }
        return stringBuffer.toString();
    }
}

