/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Set;
import com.dstc.security.cms.Attribute;
import com.dstc.security.cms.AttributeImpl;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.ContentTypeImpl;
import com.dstc.security.cms.MessageDigestImpl;
import com.dstc.security.cms.SMIMECapabilitiesImpl;
import com.dstc.security.cms.SigningTimeImpl;
import java.util.Iterator;

class AttributeFactory {
    AttributeFactory() {
    }

    static Attribute createAttribute(Asn1 asn1) throws Asn1Exception, CMSException {
        Iterator iterator = asn1.components();
        String string = ((Oid)iterator.next()).getOid();
        Set set = (Set)iterator.next();
        if (string.equals("1.2.840.113549.1.9.3")) {
            return new ContentTypeImpl(string, set);
        }
        if (string.equals("1.2.840.113549.1.9.5")) {
            return new SigningTimeImpl(string, set);
        }
        if (string.equals("1.2.840.113549.1.9.4")) {
            return new MessageDigestImpl(string, set);
        }
        if (string.equals("1.2.840.113549.1.9.15")) {
            return new SMIMECapabilitiesImpl(string, set);
        }
        return new AttributeImpl(asn1);
    }
}

