/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.CMSTypedDataInputStream;
import com.dstc.security.cms.DecryptionResult;
import com.dstc.security.cms.EnvelopedData;
import com.dstc.security.cms.EnvelopedDataImpl;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class CMSCipher {
    private static final int UNINITIALIZED = 0;
    private static final int ENCRYPT_MODE = 1;
    private static final int DECRYPT_MODE = 2;
    private int state;
    private X509Certificate[] rcptCerts;
    private String cipherAlg;
    private SecureRandom rand;
    private PrivateKey priv;
    private X509Certificate decCert;
    private InputStream src;
    private CMSTypedDataInputStream encSrc;

    public DecryptionResult decrypt() throws CMSException, IOException {
        if (this.state != 2) {
            throw new CMSException("Not initialized for decryption");
        }
        if (this.src == null) {
            throw new CMSException("Data source not yet set");
        }
        DecResult decResult = null;
        try {
            EnvelopedDataImpl envelopedDataImpl = new EnvelopedDataImpl(this.src, this.priv, this.decCert, null);
            this.src = null;
            decResult = new DecResult(envelopedDataImpl.getDecrypted(), envelopedDataImpl);
        }
        catch (CertificateException certificateException) {
            throw new CMSException("Certificate exception: " + certificateException.getMessage());
        }
        catch (Asn1Exception asn1Exception) {
            throw new CMSException("Encoding exception: " + asn1Exception.getMessage());
        }
        catch (CMSException cMSException) {
            throw cMSException;
        }
        catch (Exception exception) {
            throw new CMSException("Unexpected error: " + exception.toString());
        }
        return decResult;
    }

    public CMSTypedDataInputStream encrypt() throws CMSException, IOException {
        if (this.state != 1) {
            throw new CMSException("Not initialized for encryption");
        }
        if (this.encSrc == null) {
            throw new CMSException("Data source not yet set");
        }
        if (this.rcptCerts == null) {
            throw new CMSException("No recipients are set");
        }
        if (this.cipherAlg == null) {
            throw new CMSException("No content encryption algorithm set");
        }
        EnvelopedDataImpl envelopedDataImpl = null;
        envelopedDataImpl = new EnvelopedDataImpl(this.rand, this.cipherAlg, this.rcptCerts, this.encSrc);
        this.encSrc = null;
        return envelopedDataImpl.getEncrypted();
    }

    public void initDecrypt(PrivateKey privateKey, X509Certificate x509Certificate) throws CMSException {
        if (privateKey.getAlgorithm().equals("DSA")) {
            throw new CMSException("Cannot decrypt with a DSA private key");
        }
        if (x509Certificate.getPublicKey().getAlgorithm().equals("DSA")) {
            throw new CMSException("DSA certificate inappropriate for decryption");
        }
        this.state = 2;
        this.priv = privateKey;
        this.decCert = x509Certificate;
    }

    public void initEncrypt(SecureRandom secureRandom, X509Certificate[] x509CertificateArray, String string) throws CMSException {
        if (string == null) {
            throw new CMSException("Cannot encrypt with a null cipher algorithm");
        }
        if (!string.equals("DESede") && string.equals("RC2") && string.equals("RC2/40")) {
            throw new CMSException("Unsupported algorithm for CMS encryption");
        }
        this.state = 1;
        this.rand = secureRandom;
        this.rcptCerts = x509CertificateArray;
        this.cipherAlg = string;
    }

    public void setDataToBeDecrypted(InputStream inputStream) throws CMSException {
        if (this.state != 2) {
            throw new CMSException("Not initialized for decryption");
        }
        this.src = inputStream;
    }

    public void setDataToBeEncrypted(CMSTypedDataInputStream cMSTypedDataInputStream) throws CMSException {
        if (this.state != 1) {
            throw new CMSException("Not initialized for encryption");
        }
        this.encSrc = cMSTypedDataInputStream;
    }

    class DecResult
    implements DecryptionResult {
        private CMSTypedDataInputStream in;
        private EnvelopedDataImpl ed;

        DecResult(InputStream inputStream, EnvelopedDataImpl envelopedDataImpl) {
            this.in = new CMSTypedDataInputStream(envelopedDataImpl.getEncryptedContentType(), inputStream);
            this.ed = envelopedDataImpl;
        }

        public EnvelopedData getCMSEnvelopedData() {
            return this.ed;
        }

        public CMSTypedDataInputStream getDecrypted() {
            return this.in;
        }
    }
}

