/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.ContentInputStream;
import com.dstc.security.common.AlgorithmId;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class EncryptedContentInfo {
    private Asn1 asn1 = null;
    private Oid contentType;
    private AlgorithmId contentEncryptionAlgoId;
    private byte[] encryptedContent;
    private InputStream decrypted;

    EncryptedContentInfo(Asn1 asn1, byte[] byArray) throws Asn1Exception, IOException, CMSException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.contentType = (Oid)iterator.next();
        this.contentEncryptionAlgoId = new AlgorithmId((Asn1)iterator.next());
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12 == null) {
            return;
        }
        if (byArray != null) {
            this.decrypted = new CipherInputStream(new ContentInputStream(asn12), this.getCipher(byArray));
        }
    }

    EncryptedContentInfo(String string, InputStream inputStream, Cipher cipher) throws CMSException {
        try {
            this.asn1 = new Sequence();
            this.asn1.add(new Oid(string));
            AlgorithmParameters algorithmParameters = null;
            String string2 = cipher.getAlgorithm();
            if (string2.startsWith("DESede")) {
                algorithmParameters = AlgorithmParameters.getInstance("DESede/CBC");
                algorithmParameters.init(new IvParameterSpec(cipher.getIV()));
                this.asn1.add(new AlgorithmId("1.2.840.113549.3.7", algorithmParameters).getAsn1());
            } else if (string2.startsWith("RC2")) {
                algorithmParameters = cipher.getParameters();
                this.asn1.add(new AlgorithmId("1.2.840.113549.3.2", algorithmParameters).getAsn1());
            } else {
                throw new CMSException("Algorithm " + string2 + " unsupported for " + "encryption");
            }
            OctetString octetString = new OctetString(new CipherInputStream(inputStream, cipher));
            octetString.setTagClass(128);
            octetString.setTagNumber(0);
            this.asn1.add(octetString);
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    private Cipher getCipher(byte[] byArray) throws CMSException {
        try {
            String string = this.getContentEncryptionAlgorithm().getOid();
            AlgorithmParameters algorithmParameters = this.getContentEncryptionAlgorithm().getParams();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (string.equals("1.2.840.113549.3.2")) {
                string2 = "RC2/CBC/PKCS5Padding";
                string3 = "RC2/CBC";
                string4 = "RC2";
                string5 = "javax.crypto.spec.RC2ParameterSpec";
            } else if (string.equals("1.2.840.113549.3.7")) {
                string2 = "DESede/CBC/PKCS5Padding";
                string3 = "DESede/CBC";
                string4 = "DESede";
                string5 = "javax.crypto.spec.IvParameterSpec";
            } else {
                throw new CMSException("Algorithm OID " + string + " unsupported for CMS encryption");
            }
            Cipher cipher = Cipher.getInstance(string2);
            cipher.init(2, (Key)new SecretKeySpec(byArray, string4), (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(Class.forName(string5)), null);
            return cipher;
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    AlgorithmId getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgoId;
    }

    String getContentType() {
        return this.contentType.getOid();
    }

    InputStream getDecrypted() {
        return this.decrypted;
    }
}

