/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.x509.X509ExtensionUtil;
import java.security.cert.X509Certificate;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;

public final class SMIMEUtil {
    static final String SMIME = "application/x-pkcs7-mime";
    static final String PARAM = "smime-type";
    static final String ENVELOPED = "enveloped-data";
    static final String SIGNED = "signed-data";
    static final String MULTI = "multipart/signed";
    static final String SMIME_SIGNED = "application/x-pkcs7-mime; smime-type=signed-data";
    static final String SMIME_ENVELOPED = "application/x-pkcs7-mime; smime-type=enveloped-data";
    static final String CONTENT_TYPE_HDR = "Content-Type";
    static final String CONTENT_TRANSFER_ENCODING_HDR = "Content-Transfer-Encoding";
    static final String CONTENT_DESCRIPTION_HDR = "Content-Description";
    static final String CONTENT_DISPOSITION_HDR = "Content-Disposition";
    static final String B64 = "base64";
    static final String P7M = "\"smime.p7m\"";
    static final String ATTACH_P7M = "attachment; filename=\"smime.p7m\"";
    static final String ENC_MSG = "S/MIME Encrypted Message";
    static final String SGN_MSG = "S/MIME Signed Message";

    private SMIMEUtil() {
    }

    public static String[] getEmailAddress(X509Certificate x509Certificate) {
        return X509ExtensionUtil.getEmailAddress(x509Certificate);
    }

    static String[] getSubjectAltNames(X509Certificate x509Certificate) {
        return X509ExtensionUtil.getSubjectAltNames(x509Certificate);
    }

    public static boolean isEncrypted(MimeMessage mimeMessage) throws MessagingException {
        if (!mimeMessage.isMimeType(SMIME)) {
            return false;
        }
        return ENVELOPED.equals(new ContentType(mimeMessage.getContentType()).getParameterList().get(PARAM));
    }

    static boolean isIssuerNamePopulated(X509Certificate x509Certificate) {
        return X509ExtensionUtil.isIssuerNamePopulated(x509Certificate);
    }

    static boolean isKeyUsageEncryption(X509Certificate x509Certificate) {
        return X509ExtensionUtil.isKeyUsageEncryption(x509Certificate);
    }

    static boolean isKeyUsageKeyAgreement(X509Certificate x509Certificate) {
        return X509ExtensionUtil.isKeyUsageKeyAgreement(x509Certificate);
    }

    static boolean isKeyUsageSigning(X509Certificate x509Certificate) {
        return X509ExtensionUtil.isKeyUsageSigning(x509Certificate);
    }

    public static boolean isSigned(MimeMessage mimeMessage) throws MessagingException {
        if (mimeMessage.isMimeType(MULTI)) {
            return true;
        }
        if (!mimeMessage.isMimeType(SMIME)) {
            return false;
        }
        return SIGNED.equals(new ContentType(mimeMessage.getContentType()).getParameterList().get(PARAM));
    }

    static boolean isSubjectNamePopulated(X509Certificate x509Certificate) {
        return X509ExtensionUtil.isSubjectNamePopulated(x509Certificate);
    }

    static void setupMailcap() {
        MailcapCommandMap mailcapCommandMap = null;
        CommandMap commandMap = CommandMap.getDefaultCommandMap();
        mailcapCommandMap = commandMap instanceof MailcapCommandMap ? (MailcapCommandMap)commandMap : new MailcapCommandMap();
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;;  x-java-content-handler=com.dstc.security.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("multipart/signed;;  x-java-content-handler=com.dstc.security.smime.handlers.multipart_signed");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;;  x-java-content-handler=com.dstc.security.smime.handlers.x_pkcs7_mime");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
    }
}

