/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CertPathValidationException;
import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.ProtocolUnitInputStream;
import com.dstc.security.ssl.ProtocolUnitOutputStream;
import com.dstc.security.ssl.SSLContext;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.SSLSession;
import com.dstc.security.ssl.SSLSignature;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.TrustEngine;
import com.dstc.security.ssl.V3Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.spec.DHParameterSpec;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;

abstract class HandShaker {
    static final boolean CLIENT = true;
    static final boolean SERVER = false;
    static final int OFFSET_TO_HANDSHAKE_DATA = 4;
    static final int HANDSHAKE_NOT_YET_BEGUN = 0;
    static final int HANDSHAKE_IN_PROGRESS = 1;
    static final int HANDSHAKE_COMPLETED = 2;
    static final int HANDSHAKE_BAD_COMPLETION = 3;
    static final int CHANGE_CIPHER_SPEC = -1;
    static final byte[] TLS = new byte[]{3, 1};
    protected SSLContext ctx;
    protected SSLSocket socket;
    protected MessageDigest md5Hash;
    protected MessageDigest shaHash;
    protected SecureRandom rand;
    protected byte[] protocolVersion = V3Constants.VERSION;
    protected byte[] compressionMethods = V3Constants.COMPRESSION_METHODS;
    protected byte[] clientHelloRandom = new byte[32];
    protected byte[] serverHelloRandom = new byte[32];
    protected byte[] masterSecret;
    protected byte[] keyBlock;
    protected byte[] pendingCipherSuite;
    protected byte[][] enabledCipherSuites;
    private boolean useClientMode;
    private Vector listeners = new Vector();
    private CertificateFactory certFact;
    private MessageDigest md5;
    private MessageDigest sha;
    private X509Certificate[] peerCertChain;
    private Object lock;
    protected int handShakeState;
    protected byte[] currentId;
    protected boolean sessionReuse;
    protected TrustEngine trustEngine;
    protected SSLSignature serverSig;
    protected ByteArrayOutputStream buf = new ByteArrayOutputStream();
    protected ProtocolUnitOutputStream out;
    protected ProtocolUnitInputStream in;

    HandShaker(boolean bl, SSLSocket sSLSocket, SecureRandom secureRandom, TrustEngine trustEngine) throws SSLException {
        try {
            this.useClientMode = bl;
            this.socket = sSLSocket;
            this.ctx = sSLSocket.getContext();
            this.rand = secureRandom;
            this.in = (ProtocolUnitInputStream)sSLSocket.getInputStream();
            this.out = (ProtocolUnitOutputStream)sSLSocket.getOutputStream();
            this.trustEngine = trustEngine;
            this.lock = sSLSocket.getHandShakeLock();
            this.certFact = CertificateFactory.getInstance("X509");
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha = MessageDigest.getInstance("SHA");
            this.shaHash = MessageDigest.getInstance("SHA");
            this.md5Hash = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new SSLException(exception.getMessage());
        }
    }

    final void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.listeners.add(handshakeCompletedListener);
    }

    final boolean badCompletion() {
        return this.handShakeState == 3;
    }

    final void changeCipher(int n, int n2) throws SSLException {
        this.ctx.setKeyData(n, n2, this.keyBlock, this.serverHelloRandom, this.clientHelloRandom);
    }

    final void checkHashes(byte[] byArray, int n) throws IOException {
        byte[] byArray2 = this.computeHashes(this.useClientMode ^ true);
        if (byArray.length - n != byArray2.length) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLHandshakeException("Bad handshake hashes");
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray2[n2] != byArray[n2 + n]) {
                this.handShakeState = 3;
                this.sendAlert((byte)2, (byte)40);
                throw new SSLHandshakeException("Bad handshake hashes");
            }
            ++n2;
        }
    }

    final byte[] computeHashes(boolean bl) {
        return this.ctx.getMac().computeHashes(this.shaHash, this.md5Hash, this.masterSecret, bl);
    }

    final void computeKeyBlock() throws IOException {
        this.keyBlock = this.ctx.getMac().computeKeyBlock(this.masterSecret, this.clientHelloRandom, this.serverHelloRandom);
    }

    final void computeMasterSecret(byte[] byArray) throws IOException {
        this.masterSecret = this.ctx.getMac().computeMasterSecret(byArray, this.clientHelloRandom, this.serverHelloRandom);
    }

    static boolean dhParamsMatch(DHParameterSpec dHParameterSpec, DHParameterSpec dHParameterSpec2) {
        if (dHParameterSpec == null || dHParameterSpec2 == null) {
            return dHParameterSpec == dHParameterSpec2;
        }
        return dHParameterSpec.getG().equals(dHParameterSpec2.getG()) && dHParameterSpec.getP().equals(dHParameterSpec2.getP());
    }

    final byte[] generateHashes() {
        return this.computeHashes(this.useClientMode);
    }

    static HandShaker getInstance(boolean bl, SSLSocket sSLSocket, SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine) throws SSLException {
        if (bl) {
            return new ClientHandShaker(sSLSocket, secureRandom, privateKey, x509CertificateArray, trustEngine);
        }
        return new ServerHandShaker(sSLSocket, secureRandom, privateKey, x509CertificateArray, trustEngine);
    }

    final SSLSignature getServerSignature() {
        return this.serverSig;
    }

    final boolean handShakeCompleted() {
        return this.handShakeState == 2 || this.handShakeState == 3;
    }

    final boolean handShakeNotYetBegun() {
        return this.handShakeState == 0;
    }

    final boolean handShakeStarted() {
        return this.handShakeState == 1;
    }

    final boolean isDiffieHellmanEphKeyX() {
        return this.ctx.isPendingCipherSuiteDHE();
    }

    final boolean isDiffieHellmanKeyX() {
        return this.ctx.isPendingKeyXDH();
    }

    final boolean isExportable() {
        return this.ctx.isPendingExportable();
    }

    static boolean keyCanSign(Key key) {
        return key != null && !HandShaker.keyIsDH(key);
    }

    static boolean keyIsDH(Key key) {
        if (key == null) {
            return false;
        }
        String string = key.getAlgorithm();
        return string.equals("DH") || string.equals("Diffie-Hellman");
    }

    abstract void nextMessage(SSLProtocolUnit var1) throws IOException;

    final void processPeerCertChain(byte[] byArray, int n, int n2) throws IOException {
        try {
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            int n3 = n;
            while (n3 < n + n2) {
                int n4 = (byArray[n3] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3 + 2] & 0xFF;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n3 += 3, n4);
                vector.addElement((X509Certificate)this.certFact.generateCertificate(byteArrayInputStream));
                n3 += n4;
            }
            this.peerCertChain = new X509Certificate[vector.size()];
            vector.toArray(this.peerCertChain);
            this.trustEngine.validateCertPath(this.peerCertChain);
            if (Debug.debug >= 1) {
                com.dstc.security.util.Debug.debug("\nReceived certs");
                int n5 = 0;
                while (n5 < this.peerCertChain.length) {
                    com.dstc.security.util.Debug.debug(this.peerCertChain[n5].toString());
                    ++n5;
                }
                com.dstc.security.util.Debug.debug("");
            }
            this.processPeerPublicKey(this.peerCertChain[0].getPublicKey());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)42);
            throw new SSLHandshakeException(certificateEncodingException.getMessage());
        }
        catch (CertificateExpiredException certificateExpiredException) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)45);
            throw new SSLHandshakeException(certificateExpiredException.getMessage());
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)45);
            throw new SSLHandshakeException(certificateNotYetValidException.getMessage());
        }
        catch (CertificateException certificateException) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)42);
            throw new SSLHandshakeException(certificateException.getMessage());
        }
        catch (KeyException keyException) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)46);
            throw new SSLKeyException(keyException.getMessage());
        }
        catch (CertPathValidationException certPathValidationException) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)42);
            throw new SSLHandshakeException(certPathValidationException.getMessage());
        }
    }

    abstract void processPeerPublicKey(PublicKey var1) throws KeyException;

    final byte[] processSenderCerts(X509Certificate[] x509CertificateArray) throws IOException {
        if (x509CertificateArray == null) {
            x509CertificateArray = new X509Certificate[]{};
        }
        try {
            this.buf.reset();
            int n = 0;
            while (n < x509CertificateArray.length) {
                byte[] byArray = x509CertificateArray[n].getEncoded();
                this.buf.write((byte)(byArray.length >> 16 & 0xFF));
                this.buf.write((byte)(byArray.length >> 8 & 0xFF));
                this.buf.write((byte)(byArray.length & 0xFF));
                this.buf.write(byArray);
                ++n;
            }
            return this.buf.toByteArray();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLKeyException("Bad certificate encoding");
        }
    }

    final void reset() throws SSLException {
        this.shaHash.reset();
        this.md5Hash.reset();
        this.pendingCipherSuite = null;
    }

    final void sendAlert(byte by, byte by2) throws IOException {
        javax.net.ssl.SSLSession sSLSession;
        if (by == 2 && (sSLSession = this.socket.getSession()) != null) {
            sSLSession.invalidate();
        }
        this.out.writeAlert(by, by2);
    }

    final void sendCertificates(X509Certificate[] x509CertificateArray) throws IOException {
        byte[] byArray = this.processSenderCerts(x509CertificateArray);
        this.buf.reset();
        this.buf.write((byte)(byArray.length >> 16 & 0xFF));
        this.buf.write((byte)(byArray.length >> 8 & 0xFF));
        this.buf.write((byte)(byArray.length & 0xFF));
        this.buf.write(byArray);
        this.sendHandShake((byte)11, this.buf.toByteArray());
    }

    final void sendHandShake(byte by, byte[] byArray) throws IOException {
        HandShake handShake = new HandShake(by, byArray);
        if (by != 0) {
            this.updateHashes(handShake.getBytes());
        }
        this.out.writeHandShake(handShake);
    }

    abstract void setEnabledCipherSuites(String[] var1);

    final void setPendingCipherSuite(byte[] byArray) {
        this.pendingCipherSuite = byArray;
        this.ctx.setPendingCipherSpec(byArray);
    }

    final void signalHandshakeCompleted() {
        SSLSession sSLSession;
        if (!this.sessionReuse) {
            sSLSession = new SSLSession(this.socket, this.currentId, this.masterSecret, this.pendingCipherSuite, this.ctx.getPendingProtocolVersion(), this.peerCertChain);
            sSLSession.addToCache();
            if (Debug.debug >= 1) {
                System.out.println("\nNew session");
                System.out.println(sSLSession.toString());
            }
        } else {
            sSLSession = (SSLSession)this.socket.getSessionCache().getSession(this.currentId);
            sSLSession.updateAccessTime();
            this.socket.setSession(sSLSession);
            if (Debug.debug >= 1) {
                System.out.println("\nReusing session");
                System.out.println(sSLSession.toString());
            }
        }
        HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this.socket, sSLSession);
        int n = 0;
        while (n < this.listeners.size()) {
            ((HandshakeCompletedListener)this.listeners.elementAt(n)).handshakeCompleted(handshakeCompletedEvent);
            ++n;
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    void start() throws IOException {
    }

    abstract void startHandShake() throws IOException;

    final void updateHashes(byte[] byArray) {
        this.md5Hash.update(byArray);
        this.shaHash.update(byArray);
    }
}

