/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.SSLSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

final class LayeredSSLSocket
extends SSLSocket {
    private final Socket sock;
    private final InetAddress peerAddress;
    private final int peerPort;
    private final boolean autoClose;

    protected LayeredSSLSocket(Socket socket, String string, int n, boolean bl) throws UnknownHostException, IOException {
        this.sock = socket;
        this.peerAddress = InetAddress.getByName(string);
        this.peerPort = n;
        this.autoClose = bl;
    }

    public void close() throws IOException {
        super.close();
        if (this.autoClose) {
            this.sock.close();
        }
    }

    public InetAddress getInetAddress() {
        return this.peerAddress;
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public int getPort() {
        return this.peerPort;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.sock.getReceiveBufferSize();
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return this.sock.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.sock.getSoLinger();
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.sock.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.sock.getTcpNoDelay();
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        this.sock.setReceiveBufferSize(n);
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
        this.sock.setSendBufferSize(n);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.sock.setSoLinger(bl, n);
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.sock.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.sock.setTcpNoDelay(bl);
    }
}

