/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.common.X500Name;
import com.dstc.security.ssl.BasicTrustEngine;
import com.dstc.security.ssl.CertChecker;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class OptimisticCRLChecker
extends CertChecker {
    private final X509CRL[] crls;

    public OptimisticCRLChecker(Collection collection) {
        Collection collection2 = collection;
        synchronized (collection2) {
            X509CRL[] x509CRLArray = new X509CRL[collection.size()];
            collection.toArray(x509CRLArray);
            this.crls = x509CRLArray;
        }
    }

    public OptimisticCRLChecker(X509CRL[] x509CRLArray) {
        this.crls = (X509CRL[])x509CRLArray.clone();
    }

    public void checkCert(X509Certificate x509Certificate, Date date) throws CertificateException {
        Principal principal = x509Certificate.getIssuerDN();
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        int n = 0;
        while (n < this.crls.length) {
            X509CRL x509CRL = this.crls[n];
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(bigInteger);
            if (x509CRLEntry != null && this.equalDN(x509CRL.getIssuerDN(), principal) && x509CRLEntry.getRevocationDate().before(date)) {
                String string = x509CRLEntry.getRevocationDate().toString();
                throw new CertificateExpiredException("Cert [IssuerDN=\"" + principal + "\", SerialNumber=" + bigInteger + "] CRL RevocationDate=" + string);
            }
            ++n;
        }
    }

    protected boolean equalDN(Principal principal, Principal principal2) {
        return X500Name.equals(principal, principal2);
    }

    public static Collection getCRLs(InputStream inputStream) throws CertificateException, CRLException, IOException {
        inputStream = BasicTrustEngine.markableInputStream(inputStream);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<CRL> arrayList = new ArrayList<CRL>();
        while (!BasicTrustEngine.isEOF(inputStream)) {
            arrayList.add(certificateFactory.generateCRL(inputStream));
        }
        return arrayList;
    }
}

