/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.SSLMac;
import com.dstc.security.ssl.TLSMac;
import com.dstc.security.ssl.V3Mac;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLProtocolException;

final class SSLContext {
    static final int CLIENT = 0;
    static final int SERVER = 1;
    static final int READ = 0;
    static final int WRITE = 1;
    static final int SEQNUM_BYTES = 8;
    private HandShaker handShaker;
    private Cipher[] cipher = new Cipher[2];
    private SecretKeySpec[] keySpec = new SecretKeySpec[2];
    private IvParameterSpec[] ivSpec = new IvParameterSpec[2];
    private byte[][] macSecret = new byte[2][];
    private byte[][] seqNum = new byte[2][8];
    private int macSize;
    private byte[] pendingProtocolVersion = new byte[2];
    private boolean isPendingExportable = false;
    private boolean isPendingKeyXDH = false;
    private boolean isPendingCipherSuiteDHE = false;
    private boolean isBlockCipher = false;
    private String pendingCipherAlgName;
    private int pendingKeyLength;
    private int pendingExpKeyLength;
    private String pendingCipherSuite;
    private SSLMac sslMac;

    SSLContext() {
    }

    int doDecrypt(byte by, byte[] byArray, int n, int n2, byte[] byArray2) throws ShortBufferException, IllegalBlockSizeException, SSLProtocolException {
        byte by2;
        if (this.cipher[0] == null) {
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return n2;
        }
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("cipherText.length: " + n2);
        }
        int n3 = this.cipher[0].update(byArray, n, n2, byArray2, 0);
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("decrypted: ", byArray2);
        }
        byte by3 = by2 = this.isBlockCipher ? byArray2[n3 - 1] : (byte)0;
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("padlength: " + by2);
            com.dstc.security.util.Debug.debug("macSize: " + this.macSize);
            com.dstc.security.util.Debug.debug("isBlockCipher: " + this.isBlockCipher);
        }
        int n4 = byArray2.length - this.macSize;
        int n5 = this.isBlockCipher ? by2 + 1 : 0;
        byte[] byArray3 = new byte[this.macSize];
        System.arraycopy(byArray2, n4 -= n5, byArray3, 0, byArray3.length);
        byte[] byArray4 = this.sslMac.macMessage(this.macSecret[0], this.seqNum[0], by, byArray2, 0, n4, this.pendingProtocolVersion);
        SSLContext.increment(this.seqNum[0]);
        if (!Arrays.equals(byArray3, byArray4)) {
            com.dstc.security.util.Debug.debug("macReceived: ", byArray3);
            com.dstc.security.util.Debug.debug("macGenerated: ", byArray4);
            throw new SSLProtocolException("Bad mac received");
        }
        return n4;
    }

    int doEncrypt(byte by, byte[] byArray, int n, int n2, byte[] byArray2) throws ShortBufferException {
        if (this.cipher[1] == null) {
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return n2;
        }
        byte[] byArray3 = this.sslMac.macMessage(this.macSecret[1], this.seqNum[1], by, byArray, n, n2, this.pendingProtocolVersion);
        SSLContext.increment(this.seqNum[1]);
        int n3 = this.cipher[1].update(byArray, n, n2, byArray2, 0);
        n3 += this.cipher[1].update(byArray3, 0, byArray3.length, byArray2, n3);
        if (this.isBlockCipher) {
            int n4 = n2 + byArray3.length;
            int n5 = (n4 + 1) % this.cipher[1].getBlockSize();
            int n6 = n5 == 0 ? 0 : this.cipher[1].getBlockSize() - n5;
            byte[] byArray4 = new byte[n6 + 1];
            int n7 = 0;
            while (n7 < n6 + 1) {
                byArray4[n7] = (byte)n6;
                ++n7;
            }
            n3 += this.cipher[1].update(byArray4, 0, byArray4.length, byArray2, n3);
            if (Debug.debug >= 3) {
                com.dstc.security.util.Debug.debug("padLength: " + n6);
                com.dstc.security.util.Debug.debug("rawAndMacLength: " + n4);
            }
        }
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("raw: ", byArray);
            com.dstc.security.util.Debug.debug("macBytes: ", byArray3);
            com.dstc.security.util.Debug.debug("done: " + n3);
            com.dstc.security.util.Debug.debug("cipherText: ", byArray2);
        }
        return n3;
    }

    HandShaker getHandShaker() {
        return this.handShaker;
    }

    SSLMac getMac() {
        return this.sslMac;
    }

    byte[] getPendingProtocolVersion() {
        return this.pendingProtocolVersion;
    }

    private static void increment(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] != 0) break;
        }
    }

    boolean isPendingCipherSuiteDHE() {
        return this.isPendingCipherSuiteDHE;
    }

    boolean isPendingExportable() {
        return this.isPendingExportable;
    }

    boolean isPendingKeyXDH() {
        return this.isPendingKeyXDH;
    }

    void setHandShaker(HandShaker handShaker) throws IOException {
        this.handShaker = handShaker;
        this.handShaker.start();
    }

    void setKeyData(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            if (Debug.debug >= 3) {
                com.dstc.security.util.Debug.debug("keyBlock: ", byArray);
            }
            String string = this.pendingCipherAlgName;
            int n3 = this.pendingKeyLength;
            int n4 = this.pendingExpKeyLength;
            if (!string.equals("RC4") && !string.equals("NULL")) {
                this.isBlockCipher = true;
            }
            String string2 = this.isBlockCipher ? "/CBC/NoPadding" : "";
            String string3 = String.valueOf(string) + string2;
            this.cipher[n2] = string.equals("NULL") ? new NullCipher() : Cipher.getInstance(string3);
            int n5 = this.cipher[n2].getBlockSize();
            this.macSize = this.sslMac.getMacSize();
            if (string.equals("NULL")) {
                this.keySpec[n2] = null;
                this.ivSpec[n2] = null;
            } else if (this.isPendingExportable()) {
                this.keySpec[n2] = new SecretKeySpec(this.sslMac.exportableKey(n, byArray3, byArray2, byArray, this.macSize * 2 + n * n3, n3), 0, n4, string);
                this.ivSpec[n2] = new IvParameterSpec(this.sslMac.exportableIV(n, byArray3, byArray2, n5));
            } else {
                this.keySpec[n2] = new SecretKeySpec(byArray, this.macSize * 2 + n * n3, n3, string);
                this.ivSpec[n2] = new IvParameterSpec(byArray, 2 * (this.macSize + n3) + n * n5, n5);
            }
            if (Debug.debug >= 3 && this.keySpec[n2] != null && this.ivSpec[n2] != null) {
                com.dstc.security.util.Debug.debug("key: ", this.keySpec[n2].getEncoded());
                com.dstc.security.util.Debug.debug("iv: ", this.ivSpec[n2].getIV());
            }
            this.cipher[n2].init(n2 == 0 ? 2 : 1, (Key)this.keySpec[n2], this.ivSpec[n2], null);
            this.macSecret[n2] = new byte[this.macSize];
            System.arraycopy(byArray, n * this.macSize, this.macSecret[n2], 0, this.macSize);
            byte[] byArray4 = this.seqNum[n2];
            int n6 = 0;
            while (n6 < byArray4.length) {
                byArray4[n6] = 0;
                ++n6;
            }
            if (Debug.debug >= 1) {
                com.dstc.security.util.Debug.debug("cipher changed");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Internal error: " + generalSecurityException.getMessage());
        }
    }

    protected void setPendingCipherSpec(byte[] byArray) {
        int n = CipherSuites.getIndex(byArray);
        this.pendingCipherAlgName = CipherSuites.cipherAlgName[n];
        this.pendingKeyLength = CipherSuites.keyLength[n];
        this.pendingExpKeyLength = CipherSuites.expKeyLength[n];
        this.pendingCipherSuite = CipherSuites.suiteName[n];
        if (this.pendingCipherSuite.indexOf("EXPORT") != -1) {
            this.isPendingExportable = true;
        }
        if (this.pendingCipherSuite.indexOf("DH") != -1) {
            this.isPendingKeyXDH = true;
        }
        if (this.pendingCipherSuite.indexOf("DHE") != -1) {
            this.isPendingCipherSuiteDHE = true;
        }
        this.sslMac = this.pendingProtocolVersion[1] == 0 ? new V3Mac(this.pendingCipherSuite) : new TLSMac(this.pendingCipherSuite);
    }

    void setPendingProtocolVersion(byte[] byArray, int n) {
        this.pendingProtocolVersion[0] = byArray[n];
        this.pendingProtocolVersion[1] = byArray[n + 1];
    }
}

