/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLServerSocket;
import com.dstc.security.ssl.SessionCache;
import com.dstc.security.ssl.TrustEngine;
import com.dstc.security.util.Dependencies;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

public class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    private final SecureRandom rand;
    private final TrustEngine trustEngine;
    private final SessionCache cache;
    private boolean sessionResumptionForbidden = false;
    private final PrivateKey privKey;
    private final X509Certificate[] serverCerts;
    private String[] enabledCipherSuites = null;
    private boolean clientAuthRequired = false;
    static /* synthetic */ Class class$com$dstc$security$ssl$SSLServerSocketFactory;

    static {
        Dependencies.check(class$com$dstc$security$ssl$SSLServerSocketFactory != null ? class$com$dstc$security$ssl$SSLServerSocketFactory : (class$com$dstc$security$ssl$SSLServerSocketFactory = SSLServerSocketFactory.class$("com.dstc.security.ssl.SSLServerSocketFactory")), true);
    }

    public SSLServerSocketFactory() {
        String string = this.getClass().getName();
        throw new UnsupportedOperationException("Cannot use default " + string + " -- use " + string + ".getInstance(...) instead");
    }

    private SSLServerSocketFactory(SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String[] stringArray) {
        this.rand = secureRandom == null ? new SecureRandom() : secureRandom;
        this.rand.nextInt();
        this.trustEngine = trustEngine;
        this.cache = new SessionCache();
        this.privKey = privateKey;
        this.serverCerts = x509CertificateArray;
        this.setDefaultCipherSuites(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        SSLServerSocket sSLServerSocket = new SSLServerSocket(n);
        sSLServerSocket.init(this);
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        SSLServerSocket sSLServerSocket = new SSLServerSocket(n, n2);
        sSLServerSocket.init(this);
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket = new SSLServerSocket(n, n2, inetAddress);
        sSLServerSocket.init(this);
        return sSLServerSocket;
    }

    boolean getClientAuthRequired() {
        return this.clientAuthRequired;
    }

    public String[] getDefaultCipherSuites() {
        return this.enabledCipherSuites;
    }

    String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public static SSLServerSocketFactory getInstance(SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String[] stringArray) {
        return new SSLServerSocketFactory(secureRandom, privateKey, x509CertificateArray, trustEngine, stringArray);
    }

    public static SSLServerSocketFactory getInstance(SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String[] stringArray, int n, int n2) {
        SSLServerSocketFactory sSLServerSocketFactory = new SSLServerSocketFactory(secureRandom, privateKey, x509CertificateArray, trustEngine, stringArray);
        sSLServerSocketFactory.cache.setCacheLimit(n);
        sSLServerSocketFactory.cache.setLifetime(n2);
        return sSLServerSocketFactory;
    }

    SecureRandom getRandom() {
        return this.rand;
    }

    X509Certificate[] getServerCertificates() {
        return this.serverCerts;
    }

    PrivateKey getServerPrivateKey() {
        return this.privKey;
    }

    SessionCache getSessionCache() {
        return this.cache;
    }

    boolean getSessionResumptionForbidden() {
        return this.sessionResumptionForbidden;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuites.suiteName;
    }

    TrustEngine getTrustEngine() {
        return this.trustEngine;
    }

    public void setDebugLevel(int n) {
        Debug.debug = n;
    }

    void setDefaultCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray == null ? this.getSupportedCipherSuites() : stringArray;
    }

    public void setNeedClientAuth(boolean bl) {
        this.clientAuthRequired = bl;
    }

    public void setSessionResumptionForbidden(boolean bl) {
        this.sessionResumptionForbidden = bl;
    }
}

