/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.common.X500Name;
import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.DHServerKeyExchanger;
import com.dstc.security.ssl.DSASignature;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.RSAServerKeyExchanger;
import com.dstc.security.ssl.RSASignature;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.SSLSession;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.ServerKeyExchanger;
import com.dstc.security.ssl.TrustEngine;
import com.dstc.security.ssl.V2ClientHello;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

final class ServerHandShaker
extends HandShaker {
    private static final int V2_CLIENT_HELLO = -2;
    private ServerKeyExchanger keyX;
    private PublicKey clientPubKey;
    private PrivateKey serverPrivKey;
    private X509Certificate[] serverCertPath;
    private X509Certificate serverCert;
    private boolean needTempKeyGeneration;
    private int keyLength;
    private int last;
    private boolean clientAuthenticated = false;

    ServerHandShaker(SSLSocket sSLSocket, SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine) throws SSLException {
        super(false, sSLSocket, secureRandom, trustEngine);
        this.currentId = new byte[32];
        if (privateKey == null) {
            throw new SSLException("SSL server not configured with private key");
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new SSLException("SSL server not configured with server certs");
        }
        try {
            this.serverPrivKey = privateKey;
            String string = privateKey.getAlgorithm();
            if (string.equals("DSA")) {
                this.serverSig = new DSASignature();
            } else if (string.equals("RSA")) {
                this.serverSig = new RSASignature();
            } else if (HandShaker.keyIsDH(privateKey)) {
                this.serverSig = null;
            } else {
                throw new SSLException("Unsupported public key algorithm: " + string);
            }
            this.serverCertPath = x509CertificateArray;
            this.serverCert = x509CertificateArray[0];
            this.setEnabledCipherSuites(sSLSocket.getEnabledCipherSuites());
        }
        catch (Exception exception) {
            throw new SSLException(exception.getMessage());
        }
    }

    private void getClientHello(byte[] byArray, int n) throws IOException {
        int n2 = n;
        if (byArray[n2 + 1] <= this.protocolVersion[1]) {
            this.ctx.setPendingProtocolVersion(byArray, n2);
        } else {
            this.ctx.setPendingProtocolVersion(this.protocolVersion, 0);
        }
        System.arraycopy(byArray, n2 += 2, this.clientHelloRandom, 0, 32);
        byte by = byArray[n2 += 32];
        byte[] byArray2 = this.setSessionId(byArray, ++n2, by);
        int n3 = ((byArray[n2 += by] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF) / 2;
        n2 += 2;
        byte[][] byArray3 = new byte[n3][];
        int n4 = 0;
        while (n4 < n3) {
            byArray3[n4] = new byte[2];
            byArray3[n4][0] = byArray[n2];
            byArray3[n4][1] = byArray[n2 + 1];
            n2 += 2;
            ++n4;
        }
        this.setCipherSuite(byArray2, byArray3);
        by = byArray[n2];
        byte[] byArray4 = new byte[by];
        System.arraycopy(byArray, ++n2, byArray4, 0, by);
    }

    private void getV2ClientHello(byte[] byArray, int n) throws IOException {
        Object object;
        int n2 = n;
        byte by = byArray[n2];
        if (byArray[++n2 + 1] <= this.protocolVersion[1]) {
            this.ctx.setPendingProtocolVersion(byArray, n2);
        } else {
            this.ctx.setPendingProtocolVersion(this.protocolVersion, 0);
        }
        int n3 = ((byArray[n2 += 2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF) / 3;
        int n4 = (byArray[n2 += 2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        int n5 = (byArray[n2 += 2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        n2 += 2;
        Vector<byte[]> vector = new Vector<byte[]>();
        int n6 = 0;
        while (n6 < n3) {
            object = new byte[2];
            boolean bl = false;
            switch (byArray[n2]) {
                case 1: {
                    object[1] = 4;
                    bl = true;
                    break;
                }
                case 2: {
                    object[1] = 3;
                    bl = true;
                    break;
                }
                case 4: {
                    object[1] = 6;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                vector.addElement((byte[])object);
            }
            n2 += 3;
            ++n6;
        }
        object = new byte[vector.size()][];
        vector.toArray((T[])object);
        byte[] byArray2 = this.setSessionId(byArray, n2, n4);
        this.setCipherSuite(byArray2, (byte[][])object);
        System.arraycopy(byArray, n2 += n4, this.clientHelloRandom, 32 - n5, n5);
    }

    final void nextMessage(SSLProtocolUnit sSLProtocolUnit) throws IOException {
        int n;
        byte[] byArray = sSLProtocolUnit.getBytes();
        if (sSLProtocolUnit.getContentType() == 20) {
            n = -1;
        } else if (sSLProtocolUnit instanceof V2ClientHello) {
            n = -2;
        } else if (sSLProtocolUnit instanceof HandShake) {
            n = ((HandShake)sSLProtocolUnit).getMessageType();
        } else {
            throw new SSLException("bad message");
        }
        switch (n) {
            case -2: {
                this.handShakeState = 1;
                this.updateHashes(byArray);
                this.getV2ClientHello(sSLProtocolUnit.getBytes(), 0);
                this.respondToClientHello();
                break;
            }
            case 1: {
                this.handShakeState = 1;
                this.updateHashes(byArray);
                this.getClientHello(byArray, 4);
                this.respondToClientHello();
                break;
            }
            case 11: {
                if (!this.socket.getNeedClientAuth()) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Certificates not requested but received");
                }
                if (this.last != 1 && this.last != -2) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                this.updateHashes(byArray);
                this.processCertificates(byArray, 4);
                break;
            }
            case 16: {
                if (this.last != 11 && this.last != 1 && this.last != -2) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                try {
                    this.updateHashes(byArray);
                    this.computeMasterSecret(this.keyX.getPreMasterSecret(byArray, 4, this.clientPubKey));
                    break;
                }
                catch (SSLException sSLException) {
                    this.handShakeState = 3;
                    this.sendAlert((byte)2, (byte)40);
                    throw sSLException;
                }
            }
            case 15: {
                if (this.last != 16) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                try {
                    this.processCertificateVerify(byArray, 4);
                    this.updateHashes(byArray);
                    break;
                }
                catch (SSLException sSLException) {
                    this.handShakeState = 3;
                    this.sendAlert((byte)2, (byte)40);
                    throw sSLException;
                }
            }
            case -1: {
                if (this.last != 16 && this.last != 15 && this.last != 1 && this.last != -2) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                if (!this.sessionReuse) {
                    this.computeKeyBlock();
                }
                if (this.socket.getNeedClientAuth() && !this.sessionReuse && !this.clientAuthenticated) {
                    this.sendAlert((byte)2, (byte)40);
                    throw new SSLHandshakeException("Client did not authenticate");
                }
                this.changeCipher(0, 0);
                break;
            }
            case 20: {
                if (this.last != -1) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                this.checkHashes(byArray, 4);
                this.updateHashes(byArray);
                if (!this.sessionReuse) {
                    this.out.writeChangeCipherSpec();
                    this.changeCipher(1, 1);
                    this.sendHandShake((byte)20, this.generateHashes());
                }
                this.handShakeState = 2;
                this.signalHandshakeCompleted();
                this.reset();
                return;
            }
        }
        this.last = n;
        this.in.readHandShake();
    }

    private byte[] processAcceptableCAs(Vector vector) throws IOException {
        try {
            this.buf.reset();
            int n = 0;
            while (n < vector.size()) {
                X500Name x500Name = (X500Name)vector.elementAt(n);
                byte[] byArray = x500Name.getAsn1().getEncoded();
                this.buf.write((byte)(byArray.length >> 8 & 0xFF));
                this.buf.write((byte)(byArray.length & 0xFF));
                this.buf.write(byArray);
                ++n;
            }
            return this.buf.toByteArray();
        }
        catch (Asn1Exception asn1Exception) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLKeyException(asn1Exception.getMessage());
        }
    }

    private void processCertificateVerify(byte[] byArray, int n) throws IOException {
        if (this.clientPubKey == null) {
            throw new SSLProtocolException("Certificate not received");
        }
        if (!HandShaker.keyCanSign(this.clientPubKey)) {
            throw new SSLProtocolException("Non-signing key type:  " + this.clientPubKey.getAlgorithm());
        }
        int n2 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n + 2, byArray2, 0, n2);
        this.verifyClientSignature(this.ctx.getMac().toBeSignedCV(this.clientPubKey.getAlgorithm(), this.shaHash, this.md5Hash, this.masterSecret), byArray2);
    }

    private void processCertificates(byte[] byArray, int n) throws IOException {
        int n2 = (byArray[n] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
        if (n2 > 0) {
            this.processPeerCertChain(byArray, n + 3, n2);
        } else if (this.socket.getNeedClientAuth()) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLPeerUnverifiedException("Client refused to authenticate");
        }
    }

    void processPeerPublicKey(PublicKey publicKey) throws InvalidKeyException {
        this.clientPubKey = publicKey;
    }

    private void respondToClientHello() throws IOException {
        this.sendServerHello();
        try {
            if (this.serverSig != null) {
                this.serverSig.initSign(this.serverPrivKey, this.clientHelloRandom, this.serverHelloRandom);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            this.sendAlert((byte)2, (byte)40);
            throw new SSLKeyException(invalidKeyException.getMessage());
        }
        if (this.sessionReuse) {
            this.out.writeChangeCipherSpec();
            this.computeKeyBlock();
            this.changeCipher(1, 1);
            this.sendHandShake((byte)20, this.generateHashes());
            return;
        }
        this.sendCertificates(this.serverCertPath);
        if (this.needTempKeyGeneration) {
            this.sendServerKeyExchange(this.keyLength);
        }
        if (this.socket.getNeedClientAuth()) {
            this.clientAuthenticated = false;
            this.sendCertificateRequest();
        }
        this.sendHandShake((byte)14, null);
    }

    private void sendCertificateRequest() throws IOException {
        if (this.trustEngine.getTrustedCerts() == null) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLKeyException("No trusted CA certs set");
        }
        Vector<X500Name> vector = new Vector<X500Name>();
        Iterator iterator = this.trustEngine.getTrustedCerts();
        if (iterator != null) {
            while (iterator.hasNext()) {
                vector.addElement(new X500Name(((X509Certificate)iterator.next()).getSubjectDN().getName()));
            }
        }
        byte[] byArray = this.processAcceptableCAs(vector);
        this.buf.reset();
        byte[] byArray2 = new byte[]{1, 2};
        this.buf.write((byte)(byArray2.length & 0xFF));
        this.buf.write(byArray2);
        this.buf.write((byte)(byArray.length >> 8 & 0xFF));
        this.buf.write((byte)(byArray.length & 0xFF));
        this.buf.write(byArray);
        this.sendHandShake((byte)13, this.buf.toByteArray());
    }

    private void sendServerHello() throws IOException {
        this.handShakeState = 1;
        this.buf.reset();
        this.ctx.setPendingProtocolVersion(this.protocolVersion, 0);
        this.buf.write(this.protocolVersion);
        this.rand.nextBytes(this.serverHelloRandom);
        this.buf.write(this.serverHelloRandom);
        this.buf.write((byte)(this.currentId.length & 0xFF));
        this.buf.write(this.currentId);
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("\nChosen Cipher Suite");
            com.dstc.security.util.Debug.debug(String.valueOf(CipherSuites.getSuiteName(this.pendingCipherSuite)) + "\n");
        }
        this.buf.write(this.pendingCipherSuite);
        this.buf.write(this.compressionMethods[0]);
        this.sendHandShake((byte)2, this.buf.toByteArray());
    }

    private void sendServerKeyExchange(int n) throws IOException {
        this.handShakeState = 1;
        this.sendHandShake((byte)12, this.keyX.getServerKey(n));
    }

    private void setCipherSuite(byte[] byArray, byte[][] byArray2) throws IOException {
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("\nOffered Cipher Suite");
            int n = 0;
            while (n < byArray2.length) {
                String string = CipherSuites.getSuiteName(byArray2[n]);
                if (string != null) {
                    com.dstc.security.util.Debug.debug(string);
                } else {
                    com.dstc.security.util.Debug.debug("suite: ", byArray2[n]);
                }
                ++n;
            }
            com.dstc.security.util.Debug.debug("");
        }
        if (this.enabledCipherSuites.length == 0) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLHandshakeException("No cipher suites compatible with server key");
        }
        if (byArray != null) {
            if (!this.suiteSupported(byArray2, byArray)) {
                this.sendAlert((byte)2, (byte)40);
                throw new SSLHandshakeException("Session to be resumed requires a ciphersuite which was not offered");
            }
            if (!this.suiteSupported(this.enabledCipherSuites, byArray)) {
                this.sendAlert((byte)2, (byte)40);
                throw new SSLHandshakeException("Cannot support ciphersuite for resumption");
            }
            this.setPendingCipherSuite(byArray);
        } else {
            int n = 0;
            while (n < byArray2.length) {
                byte[] byArray3 = byArray2[n];
                if (this.suiteSupported(this.enabledCipherSuites, byArray3)) {
                    this.setPendingCipherSuite(byArray3);
                    break;
                }
                ++n;
            }
            if (this.pendingCipherSuite == null) {
                this.handShakeState = 3;
                this.sendAlert((byte)2, (byte)40);
                throw new SSLHandshakeException("Cannot support offered cipher suites");
            }
        }
        this.keyX = this.isDiffieHellmanKeyX() ? new DHServerKeyExchanger(this, this.rand, this.serverPrivKey, this.serverCert.getPublicKey()) : new RSAServerKeyExchanger(this, this.rand, this.serverPrivKey);
        if (this.isDiffieHellmanEphKeyX()) {
            this.needTempKeyGeneration = true;
            this.keyLength = 1024;
            if (this.isExportable()) {
                this.keyLength = 512;
            }
        } else if (this.isExportable()) {
            this.needTempKeyGeneration = true;
            this.keyLength = 512;
        }
    }

    void setClientAuthenticated() {
        this.clientAuthenticated = true;
    }

    final void setEnabledCipherSuites(String[] stringArray) {
        int n;
        Object object;
        if (stringArray[0].indexOf("TLS") != -1) {
            this.protocolVersion = HandShaker.TLS;
        }
        Object object2 = new byte[stringArray.length][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string;
            object = stringArray[n3].substring(4);
            n = 1;
            if (this.serverSig != null) {
                string = this.serverPrivKey.getAlgorithm();
                if (string.equals("RSA")) {
                    if (((String)object).indexOf("RSA") == -1) {
                        n = 0;
                    }
                } else if (string.equals("DSA") && ((String)object).indexOf("DSS") == -1) {
                    n = 0;
                }
            } else {
                if (((String)object).indexOf("DH_") == -1) {
                    n = 0;
                }
                if ((string = this.serverCert.getSigAlgName()).indexOf("DSA") != -1) {
                    if (((String)object).indexOf("DSS") == -1) {
                        n = 0;
                    }
                } else if (((String)object).indexOf("RSA") == -1) {
                    n = 0;
                }
            }
            if (n != 0) {
                int n4 = 0;
                while (n4 < CipherSuites.suiteName.length) {
                    if (((String)object).equals(CipherSuites.suiteName[n4])) {
                        object2[n2++] = CipherSuites.suiteType[n4];
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        if (n2 < ((byte[][])object2).length) {
            object = new byte[n2][];
            n = 0;
            while (n < n2) {
                object[n] = object2[n];
                ++n;
            }
            object2 = object;
        }
        this.enabledCipherSuites = object2;
    }

    private byte[] setSessionId(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        SSLSession sSLSession = (SSLSession)this.socket.getSessionCache().getSession(byArray2);
        if (!this.socket.getEnableSessionCreation() && sSLSession == null) {
            this.sendAlert((byte)2, (byte)40);
            throw new SSLException("Cannot re-use session: not found in cache");
        }
        if (this.socket.getSessionResumptionForbidden()) {
            sSLSession = null;
        }
        if (sSLSession == null) {
            if (Debug.debug >= 1) {
                com.dstc.security.util.Debug.debug("New session");
            }
            this.sessionReuse = false;
            this.rand.nextBytes(this.currentId);
            long l = System.currentTimeMillis();
            this.currentId[0] = (byte)(l >> 24 & 0xFFL);
            this.currentId[1] = (byte)(l >> 16 & 0xFFL);
            this.currentId[2] = (byte)(l >> 8 & 0xFFL);
            this.currentId[3] = (byte)(l & 0xFFL);
            return null;
        }
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("Session reuse");
        }
        this.currentId = byArray2;
        this.sessionReuse = true;
        this.masterSecret = sSLSession.getMasterSecret();
        return sSLSession.getSuite();
    }

    void start() throws IOException {
        this.in.readHandShake();
    }

    final void startHandShake() throws IOException {
        if (this.handShakeStarted()) {
            return;
        }
        this.reset();
        this.handShakeState = 1;
        this.sendHandShake((byte)0, null);
        this.in.readHandShake();
    }

    private boolean suiteSupported(byte[][] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            if (Arrays.equals(byArray[n], byArray2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void verifyClientSignature(byte[] byArray, byte[] byArray2) throws IOException {
        try {
            String string = this.clientPubKey.getAlgorithm();
            Signature signature = Signature.getInstance("Raw" + string);
            signature.initVerify(this.clientPubKey);
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                this.handShakeState = 3;
                this.sendAlert((byte)2, (byte)40);
                throw new SSLHandshakeException("Bad signature");
            }
            this.clientAuthenticated = true;
        }
        catch (Exception exception) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLException(exception.getMessage());
        }
    }
}

