/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLMac;
import com.dstc.security.ssl.V3Constants;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.ProviderException;

class V3Mac
implements SSLMac {
    private static final String DIG_ERR = "Internal error: partial digest";
    private static final int MD5_LEN = 16;
    private static final int SHA_LEN = 20;
    private MessageDigest md;
    private MessageDigest md5;
    private MessageDigest sha;
    private int padSize;
    private byte[] lengthOctets = new byte[2];
    private int mdLen;
    private byte[] mdTemp = new byte[20];

    V3Mac(String string) {
        try {
            if (string.endsWith("MD5")) {
                this.md = MessageDigest.getInstance("MD5");
                this.padSize = 48;
                this.mdLen = 16;
            } else {
                this.md = MessageDigest.getInstance("SHA");
                this.padSize = 40;
                this.mdLen = 20;
            }
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            throw new ProviderException(exception.getMessage());
        }
    }

    public byte[] computeHashes(MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray, boolean bl) {
        byte[] byArray2 = bl ? V3Constants.CLIENT : V3Constants.SERVER;
        return this.hash(messageDigest, messageDigest2, byArray, byArray2, 0);
    }

    public byte[] computeKeyBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("masterSecret: ", byArray);
        }
        byte[] byArray4 = new byte[112];
        int n = 0;
        while (n < 7) {
            this.doubleHash(byArray, V3Constants.SALTS[n], byArray3, byArray2, byArray4, 16 * n);
            ++n;
        }
        return byArray4;
    }

    public byte[] computeMasterSecret(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[48];
        int n = 0;
        while (n < 3) {
            this.doubleHash(byArray, V3Constants.SALTS[n], byArray2, byArray3, byArray4, 16 * n);
            ++n;
        }
        return byArray4;
    }

    private final void doubleHash(byte[] byArray, String string, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
        this.md5.update(byArray);
        this.sha.update(string.getBytes());
        this.sha.update(byArray);
        this.sha.update(byArray2);
        this.sha.update(byArray3);
        this.md5.update(this.sha.digest());
        try {
            int n2 = this.md5.digest(byArray4, n, 16);
            if (n2 != 16) {
                throw new RuntimeException(DIG_ERR);
            }
        }
        catch (DigestException digestException) {
            throw new RuntimeException("Internal error: " + digestException.getMessage());
        }
    }

    public byte[] exportableIV(int n, byte[] byArray, byte[] byArray2, int n2) {
        if (n == 0) {
            this.md5.update(byArray);
        }
        this.md5.update(byArray2);
        if (n == 1) {
            this.md5.update(byArray);
        }
        byte[] byArray3 = this.md5.digest();
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        return byArray4;
    }

    public byte[] exportableKey(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this.md5.update(byArray3, n2, n3);
        if (n == 0) {
            this.md5.update(byArray);
        }
        this.md5.update(byArray2);
        if (n == 1) {
            this.md5.update(byArray);
        }
        return this.md5.digest();
    }

    public int getMacSize() {
        return this.mdLen;
    }

    private final byte[] hash(MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray, byte[] byArray2, int n) {
        try {
            this.sha = (MessageDigest)messageDigest.clone();
            if (byArray2 != null) {
                this.sha.update(byArray2);
            }
            this.sha.update(byArray);
            this.sha.update(V3Constants.PAD1, 0, 40);
            if (this.sha.digest(this.mdTemp, 0, 20) != 20) {
                throw new RuntimeException(DIG_ERR);
            }
            this.sha.update(byArray);
            this.sha.update(V3Constants.PAD2, 0, 40);
            this.sha.update(this.mdTemp, 0, 20);
            if (n == 1) {
                return this.sha.digest();
            }
            this.md5 = (MessageDigest)messageDigest2.clone();
            if (byArray2 != null) {
                this.md5.update(byArray2);
            }
            this.md5.update(byArray);
            this.md5.update(V3Constants.PAD1);
            if (this.md5.digest(this.mdTemp, 0, 16) != 16) {
                throw new RuntimeException(DIG_ERR);
            }
            this.md5.update(byArray);
            this.md5.update(V3Constants.PAD2);
            this.md5.update(this.mdTemp, 0, 16);
            byte[] byArray3 = new byte[36];
            if (this.md5.digest(byArray3, 0, 16) != 16) {
                throw new RuntimeException(DIG_ERR);
            }
            if (this.sha.digest(byArray3, 16, 20) != 20) {
                throw new RuntimeException(DIG_ERR);
            }
            return byArray3;
        }
        catch (DigestException digestException) {
            throw new RuntimeException("Internal error: " + digestException.getMessage());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error: " + cloneNotSupportedException.getMessage());
        }
    }

    public byte[] macMessage(byte[] byArray, byte[] byArray2, byte by, byte[] byArray3, int n, int n2, byte[] byArray4) {
        try {
            this.md.update(byArray);
            this.md.update(V3Constants.PAD1, 0, this.padSize);
            this.md.update(byArray2);
            this.md.update(by);
            this.lengthOctets[0] = (byte)(n2 >> 8 & 0xFF);
            this.lengthOctets[1] = (byte)(n2 & 0xFF);
            this.md.update(this.lengthOctets);
            this.md.update(byArray3, n, n2);
            if (this.mdLen != this.md.digest(this.mdTemp, 0, this.mdLen)) {
                throw new RuntimeException(DIG_ERR);
            }
            this.md.update(byArray);
            this.md.update(V3Constants.PAD2, 0, this.padSize);
            this.md.update(this.mdTemp, 0, this.mdLen);
            return this.md.digest();
        }
        catch (DigestException digestException) {
            throw new RuntimeException("Internal error: " + digestException.getMessage());
        }
    }

    public byte[] toBeSignedCV(String string, MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray) {
        if (string.equals("RSA")) {
            return this.hash(messageDigest, messageDigest2, byArray, null, 0);
        }
        return this.hash(messageDigest, messageDigest2, byArray, null, 1);
    }
}

