/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.Licensed;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.MacSpi;
import javax.crypto.NoSuchPaddingException;

public final class DESMAC
extends MacSpi
implements Licensed {
    protected int macLength = 8;
    private Cipher cipher;
    private int count = 0;
    private byte[] outputBuffer;

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone DESMAC");
    }

    protected byte[] engineDoFinal() {
        try {
            byte[] byArray = this.cipher.doFinal();
            byte[] byArray2 = new byte[this.macLength];
            if (byArray.length == 0) {
                System.arraycopy(this.outputBuffer, this.outputBuffer.length - this.macLength, byArray2, 0, this.macLength);
                return byArray2;
            }
            System.arraycopy(byArray, 0, byArray2, 0, this.macLength);
            return byArray2;
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("Internal error: " + badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("Internal error: " + illegalBlockSizeException.getMessage());
        }
    }

    protected void engineDoFinal(byte[] byArray, int n) {
        try {
            byte[] byArray2 = this.cipher.doFinal();
            System.arraycopy(byArray2, 0, byArray, n, this.macLength);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("Internal error: " + badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("Internal error: " + illegalBlockSizeException.getMessage());
        }
    }

    protected int engineGetMacLength() {
        return this.macLength;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.cipher = Cipher.getInstance("DES/CBC/Zeroes");
            this.cipher.init(1, key, algorithmParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal error: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException("Internal error: " + noSuchPaddingException.getMessage());
        }
    }

    protected void engineReset() {
        this.outputBuffer = new byte[0];
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.outputBuffer = this.cipher.update(byArray, n, n2);
    }
}

