/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DSAPrivateKey;
import com.dstc.security.provider.DSAPublicKey;
import com.dstc.security.provider.Licensed;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DSAKeyPairGenerator
extends KeyPairGeneratorSpi
implements Licensed {
    private DSAPrivateKey priv;
    private DSAPublicKey pub;
    private DSAParameterSpec dsaParamsSpec;
    private SecureRandom random;
    private int keyLength = 1024;
    private static final int MAX_KEY_LENGTH = 8192;
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        Object object;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.dsaParamsSpec == null) {
            if (this.keyLength == 1024) {
                this.dsaParamsSpec = new DSAParameterSpec(new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16), new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16), new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16));
            } else {
                try {
                    object = AlgorithmParameterGenerator.getInstance("DSA");
                    ((AlgorithmParameterGenerator)object).init(this.keyLength, this.random);
                    this.dsaParamsSpec = (DSAParameterSpec)((AlgorithmParameterGenerator)object).generateParameters().getParameterSpec(class$java$security$spec$DSAParameterSpec != null ? class$java$security$spec$DSAParameterSpec : (class$java$security$spec$DSAParameterSpec = DSAKeyPairGenerator.class$("java.security.spec.DSAParameterSpec")));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("Internal error: " + noSuchAlgorithmException.getMessage());
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new RuntimeException("Internal error: " + invalidParameterSpecException.getMessage());
                }
            }
        }
        object = null;
        while (((BigInteger)(object = new BigInteger(this.dsaParamsSpec.getQ().bitLength(), this.random))).compareTo(this.dsaParamsSpec.getQ()) != -1) {
        }
        this.priv = new DSAPrivateKey((BigInteger)object, (DSAParams)this.dsaParamsSpec);
        BigInteger bigInteger = this.dsaParamsSpec.getG().modPow((BigInteger)object, this.dsaParamsSpec.getP());
        this.pub = new DSAPublicKey(bigInteger, (DSAParams)this.dsaParamsSpec);
        return new KeyPair(this.pub, this.priv);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n > 8192) {
            throw new InvalidParameterException("key length too long. Max = 8192 bits");
        }
        this.random = secureRandom;
        this.keyLength = n;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not a DSA parameter spec");
        }
        int n = ((DSAParameterSpec)algorithmParameterSpec).getP().bitLength();
        if (n > 8192) {
            throw new InvalidParameterException("key length too long. Max = 8192 bits");
        }
        this.dsaParamsSpec = (DSAParameterSpec)algorithmParameterSpec;
        this.random = secureRandom;
    }
}

