/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.Licensed;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

class HMACwithAnyMD
extends MacSpi
implements Licensed {
    protected int L;
    protected MessageDigest md;
    private byte ipadByte = (byte)54;
    private byte opadByte = (byte)92;
    private int B = 64;
    private byte[] keyXORIpad;
    private byte[] keyXOROpad;
    private MessageDigest md2;

    HMACwithAnyMD() {
    }

    public Object clone() throws CloneNotSupportedException {
        HMACwithAnyMD hMACwithAnyMD = new HMACwithAnyMD();
        hMACwithAnyMD.L = this.L;
        hMACwithAnyMD.keyXORIpad = (byte[])this.keyXORIpad.clone();
        hMACwithAnyMD.keyXOROpad = (byte[])this.keyXOROpad.clone();
        hMACwithAnyMD.md = (MessageDigest)this.md.clone();
        return hMACwithAnyMD;
    }

    protected byte[] engineDoFinal() {
        byte[] byArray = this.md.digest();
        this.md.update(this.keyXOROpad);
        byte[] byArray2 = this.md.digest(byArray);
        this.md.update(this.keyXORIpad);
        return byArray2;
    }

    protected int engineGetMacLength() {
        return this.L;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No params needed for this Mac");
        }
        this.keyXORIpad = new byte[this.B];
        this.keyXOROpad = new byte[this.B];
        byte[] byArray = key.getEncoded();
        if (byArray.length > 64) {
            try {
                this.md2 = (MessageDigest)this.md.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException("Clone not supported for this MD");
            }
            byte[] byArray2 = new byte[this.L];
            byArray2 = this.md2.digest(byArray);
            byArray = byArray2;
        }
        System.arraycopy(byArray, 0, this.keyXORIpad, 0, byArray.length);
        System.arraycopy(byArray, 0, this.keyXOROpad, 0, byArray.length);
        int n = 0;
        while (n < this.B) {
            int n2 = n;
            this.keyXORIpad[n2] = (byte)(this.keyXORIpad[n2] ^ this.ipadByte);
            int n3 = n++;
            this.keyXOROpad[n3] = (byte)(this.keyXOROpad[n3] ^ this.opadByte);
        }
        this.md.reset();
        this.md.update(this.keyXORIpad);
    }

    protected void engineReset() {
        this.md.reset();
        this.md.update(this.keyXORIpad);
    }

    protected void engineUpdate(byte by) {
        this.md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }
}

