/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.Licensed;
import com.dstc.security.util.Bytes;
import java.security.DigestException;
import java.security.MessageDigestSpi;

public final class RIPEMD160
extends MessageDigestSpi
implements Cloneable,
Licensed {
    private static final int DIGEST_LENGTH = 20;
    private static final int BLOCKSIZE = 64;
    private byte[] inputBuffer = new byte[64];
    private int inputBufferOffset = 0;
    private int[] mdBuffer = new int[5];
    private int plainTextLength = 0;

    public RIPEMD160() {
        this.mdBuffer[0] = 1732584193;
        this.mdBuffer[1] = -271733879;
        this.mdBuffer[2] = -1732584194;
        this.mdBuffer[3] = 271733878;
        this.mdBuffer[4] = -1009589776;
    }

    private static void FF(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + nArray2[n6]);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void FFF(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + nArray2[n6]);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void GG(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + ((nArray[n2] & nArray[n3] | ~nArray[n2] & nArray[n4]) + nArray2[n6] + 1518500249);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void GGG(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + ((nArray[n2] & nArray[n3] | ~nArray[n2] & nArray[n4]) + nArray2[n6] + 2053994217);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void HH(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + (((nArray[n2] | ~nArray[n3]) ^ nArray[n4]) + nArray2[n6] + 1859775393);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void HHH(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + (((nArray[n2] | ~nArray[n3]) ^ nArray[n4]) + nArray2[n6] + 1836072691);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void II(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + ((nArray[n2] & nArray[n4] | nArray[n3] & ~nArray[n4]) + nArray2[n6] + -1894007588);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void III(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + ((nArray[n2] & nArray[n4] | nArray[n3] & ~nArray[n4]) + nArray2[n6] + 1548603684);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void JJ(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + ((nArray[n2] ^ (nArray[n3] | ~nArray[n4])) + nArray2[n6] + -1454113458);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    private static void JJJ(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        nArray[n8] = nArray[n8] + ((nArray[n2] ^ (nArray[n3] | ~nArray[n4])) + nArray2[n6] + 1352829926);
        nArray[n] = (nArray[n] << n7 | nArray[n] >>> 32 - n7) + nArray[n5];
        nArray[n3] = nArray[n3] << 10 | nArray[n3] >>> 22;
    }

    public Object clone() throws CloneNotSupportedException {
        RIPEMD160 rIPEMD160 = new RIPEMD160();
        rIPEMD160.inputBufferOffset = this.inputBufferOffset;
        rIPEMD160.plainTextLength = this.plainTextLength;
        System.arraycopy(this.mdBuffer, 0, rIPEMD160.mdBuffer, 0, 5);
        System.arraycopy(this.inputBuffer, 0, rIPEMD160.inputBuffer, 0, 64);
        return rIPEMD160;
    }

    private static void doDecodeBlock(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[5];
        int[] nArray4 = new int[5];
        System.arraycopy(nArray, 0, nArray3, 0, 5);
        System.arraycopy(nArray, 0, nArray4, 0, 5);
        RIPEMD160.FF(nArray3, nArray2, 0, 1, 2, 3, 4, 0, 11);
        RIPEMD160.FF(nArray3, nArray2, 4, 0, 1, 2, 3, 1, 14);
        RIPEMD160.FF(nArray3, nArray2, 3, 4, 0, 1, 2, 2, 15);
        RIPEMD160.FF(nArray3, nArray2, 2, 3, 4, 0, 1, 3, 12);
        RIPEMD160.FF(nArray3, nArray2, 1, 2, 3, 4, 0, 4, 5);
        RIPEMD160.FF(nArray3, nArray2, 0, 1, 2, 3, 4, 5, 8);
        RIPEMD160.FF(nArray3, nArray2, 4, 0, 1, 2, 3, 6, 7);
        RIPEMD160.FF(nArray3, nArray2, 3, 4, 0, 1, 2, 7, 9);
        RIPEMD160.FF(nArray3, nArray2, 2, 3, 4, 0, 1, 8, 11);
        RIPEMD160.FF(nArray3, nArray2, 1, 2, 3, 4, 0, 9, 13);
        RIPEMD160.FF(nArray3, nArray2, 0, 1, 2, 3, 4, 10, 14);
        RIPEMD160.FF(nArray3, nArray2, 4, 0, 1, 2, 3, 11, 15);
        RIPEMD160.FF(nArray3, nArray2, 3, 4, 0, 1, 2, 12, 6);
        RIPEMD160.FF(nArray3, nArray2, 2, 3, 4, 0, 1, 13, 7);
        RIPEMD160.FF(nArray3, nArray2, 1, 2, 3, 4, 0, 14, 9);
        RIPEMD160.FF(nArray3, nArray2, 0, 1, 2, 3, 4, 15, 8);
        RIPEMD160.GG(nArray3, nArray2, 4, 0, 1, 2, 3, 7, 7);
        RIPEMD160.GG(nArray3, nArray2, 3, 4, 0, 1, 2, 4, 6);
        RIPEMD160.GG(nArray3, nArray2, 2, 3, 4, 0, 1, 13, 8);
        RIPEMD160.GG(nArray3, nArray2, 1, 2, 3, 4, 0, 1, 13);
        RIPEMD160.GG(nArray3, nArray2, 0, 1, 2, 3, 4, 10, 11);
        RIPEMD160.GG(nArray3, nArray2, 4, 0, 1, 2, 3, 6, 9);
        RIPEMD160.GG(nArray3, nArray2, 3, 4, 0, 1, 2, 15, 7);
        RIPEMD160.GG(nArray3, nArray2, 2, 3, 4, 0, 1, 3, 15);
        RIPEMD160.GG(nArray3, nArray2, 1, 2, 3, 4, 0, 12, 7);
        RIPEMD160.GG(nArray3, nArray2, 0, 1, 2, 3, 4, 0, 12);
        RIPEMD160.GG(nArray3, nArray2, 4, 0, 1, 2, 3, 9, 15);
        RIPEMD160.GG(nArray3, nArray2, 3, 4, 0, 1, 2, 5, 9);
        RIPEMD160.GG(nArray3, nArray2, 2, 3, 4, 0, 1, 2, 11);
        RIPEMD160.GG(nArray3, nArray2, 1, 2, 3, 4, 0, 14, 7);
        RIPEMD160.GG(nArray3, nArray2, 0, 1, 2, 3, 4, 11, 13);
        RIPEMD160.GG(nArray3, nArray2, 4, 0, 1, 2, 3, 8, 12);
        RIPEMD160.HH(nArray3, nArray2, 3, 4, 0, 1, 2, 3, 11);
        RIPEMD160.HH(nArray3, nArray2, 2, 3, 4, 0, 1, 10, 13);
        RIPEMD160.HH(nArray3, nArray2, 1, 2, 3, 4, 0, 14, 6);
        RIPEMD160.HH(nArray3, nArray2, 0, 1, 2, 3, 4, 4, 7);
        RIPEMD160.HH(nArray3, nArray2, 4, 0, 1, 2, 3, 9, 14);
        RIPEMD160.HH(nArray3, nArray2, 3, 4, 0, 1, 2, 15, 9);
        RIPEMD160.HH(nArray3, nArray2, 2, 3, 4, 0, 1, 8, 13);
        RIPEMD160.HH(nArray3, nArray2, 1, 2, 3, 4, 0, 1, 15);
        RIPEMD160.HH(nArray3, nArray2, 0, 1, 2, 3, 4, 2, 14);
        RIPEMD160.HH(nArray3, nArray2, 4, 0, 1, 2, 3, 7, 8);
        RIPEMD160.HH(nArray3, nArray2, 3, 4, 0, 1, 2, 0, 13);
        RIPEMD160.HH(nArray3, nArray2, 2, 3, 4, 0, 1, 6, 6);
        RIPEMD160.HH(nArray3, nArray2, 1, 2, 3, 4, 0, 13, 5);
        RIPEMD160.HH(nArray3, nArray2, 0, 1, 2, 3, 4, 11, 12);
        RIPEMD160.HH(nArray3, nArray2, 4, 0, 1, 2, 3, 5, 7);
        RIPEMD160.HH(nArray3, nArray2, 3, 4, 0, 1, 2, 12, 5);
        RIPEMD160.II(nArray3, nArray2, 2, 3, 4, 0, 1, 1, 11);
        RIPEMD160.II(nArray3, nArray2, 1, 2, 3, 4, 0, 9, 12);
        RIPEMD160.II(nArray3, nArray2, 0, 1, 2, 3, 4, 11, 14);
        RIPEMD160.II(nArray3, nArray2, 4, 0, 1, 2, 3, 10, 15);
        RIPEMD160.II(nArray3, nArray2, 3, 4, 0, 1, 2, 0, 14);
        RIPEMD160.II(nArray3, nArray2, 2, 3, 4, 0, 1, 8, 15);
        RIPEMD160.II(nArray3, nArray2, 1, 2, 3, 4, 0, 12, 9);
        RIPEMD160.II(nArray3, nArray2, 0, 1, 2, 3, 4, 4, 8);
        RIPEMD160.II(nArray3, nArray2, 4, 0, 1, 2, 3, 13, 9);
        RIPEMD160.II(nArray3, nArray2, 3, 4, 0, 1, 2, 3, 14);
        RIPEMD160.II(nArray3, nArray2, 2, 3, 4, 0, 1, 7, 5);
        RIPEMD160.II(nArray3, nArray2, 1, 2, 3, 4, 0, 15, 6);
        RIPEMD160.II(nArray3, nArray2, 0, 1, 2, 3, 4, 14, 8);
        RIPEMD160.II(nArray3, nArray2, 4, 0, 1, 2, 3, 5, 6);
        RIPEMD160.II(nArray3, nArray2, 3, 4, 0, 1, 2, 6, 5);
        RIPEMD160.II(nArray3, nArray2, 2, 3, 4, 0, 1, 2, 12);
        RIPEMD160.JJ(nArray3, nArray2, 1, 2, 3, 4, 0, 4, 9);
        RIPEMD160.JJ(nArray3, nArray2, 0, 1, 2, 3, 4, 0, 15);
        RIPEMD160.JJ(nArray3, nArray2, 4, 0, 1, 2, 3, 5, 5);
        RIPEMD160.JJ(nArray3, nArray2, 3, 4, 0, 1, 2, 9, 11);
        RIPEMD160.JJ(nArray3, nArray2, 2, 3, 4, 0, 1, 7, 6);
        RIPEMD160.JJ(nArray3, nArray2, 1, 2, 3, 4, 0, 12, 8);
        RIPEMD160.JJ(nArray3, nArray2, 0, 1, 2, 3, 4, 2, 13);
        RIPEMD160.JJ(nArray3, nArray2, 4, 0, 1, 2, 3, 10, 12);
        RIPEMD160.JJ(nArray3, nArray2, 3, 4, 0, 1, 2, 14, 5);
        RIPEMD160.JJ(nArray3, nArray2, 2, 3, 4, 0, 1, 1, 12);
        RIPEMD160.JJ(nArray3, nArray2, 1, 2, 3, 4, 0, 3, 13);
        RIPEMD160.JJ(nArray3, nArray2, 0, 1, 2, 3, 4, 8, 14);
        RIPEMD160.JJ(nArray3, nArray2, 4, 0, 1, 2, 3, 11, 11);
        RIPEMD160.JJ(nArray3, nArray2, 3, 4, 0, 1, 2, 6, 8);
        RIPEMD160.JJ(nArray3, nArray2, 2, 3, 4, 0, 1, 15, 5);
        RIPEMD160.JJ(nArray3, nArray2, 1, 2, 3, 4, 0, 13, 6);
        RIPEMD160.JJJ(nArray4, nArray2, 0, 1, 2, 3, 4, 5, 8);
        RIPEMD160.JJJ(nArray4, nArray2, 4, 0, 1, 2, 3, 14, 9);
        RIPEMD160.JJJ(nArray4, nArray2, 3, 4, 0, 1, 2, 7, 9);
        RIPEMD160.JJJ(nArray4, nArray2, 2, 3, 4, 0, 1, 0, 11);
        RIPEMD160.JJJ(nArray4, nArray2, 1, 2, 3, 4, 0, 9, 13);
        RIPEMD160.JJJ(nArray4, nArray2, 0, 1, 2, 3, 4, 2, 15);
        RIPEMD160.JJJ(nArray4, nArray2, 4, 0, 1, 2, 3, 11, 15);
        RIPEMD160.JJJ(nArray4, nArray2, 3, 4, 0, 1, 2, 4, 5);
        RIPEMD160.JJJ(nArray4, nArray2, 2, 3, 4, 0, 1, 13, 7);
        RIPEMD160.JJJ(nArray4, nArray2, 1, 2, 3, 4, 0, 6, 7);
        RIPEMD160.JJJ(nArray4, nArray2, 0, 1, 2, 3, 4, 15, 8);
        RIPEMD160.JJJ(nArray4, nArray2, 4, 0, 1, 2, 3, 8, 11);
        RIPEMD160.JJJ(nArray4, nArray2, 3, 4, 0, 1, 2, 1, 14);
        RIPEMD160.JJJ(nArray4, nArray2, 2, 3, 4, 0, 1, 10, 14);
        RIPEMD160.JJJ(nArray4, nArray2, 1, 2, 3, 4, 0, 3, 12);
        RIPEMD160.JJJ(nArray4, nArray2, 0, 1, 2, 3, 4, 12, 6);
        RIPEMD160.III(nArray4, nArray2, 4, 0, 1, 2, 3, 6, 9);
        RIPEMD160.III(nArray4, nArray2, 3, 4, 0, 1, 2, 11, 13);
        RIPEMD160.III(nArray4, nArray2, 2, 3, 4, 0, 1, 3, 15);
        RIPEMD160.III(nArray4, nArray2, 1, 2, 3, 4, 0, 7, 7);
        RIPEMD160.III(nArray4, nArray2, 0, 1, 2, 3, 4, 0, 12);
        RIPEMD160.III(nArray4, nArray2, 4, 0, 1, 2, 3, 13, 8);
        RIPEMD160.III(nArray4, nArray2, 3, 4, 0, 1, 2, 5, 9);
        RIPEMD160.III(nArray4, nArray2, 2, 3, 4, 0, 1, 10, 11);
        RIPEMD160.III(nArray4, nArray2, 1, 2, 3, 4, 0, 14, 7);
        RIPEMD160.III(nArray4, nArray2, 0, 1, 2, 3, 4, 15, 7);
        RIPEMD160.III(nArray4, nArray2, 4, 0, 1, 2, 3, 8, 12);
        RIPEMD160.III(nArray4, nArray2, 3, 4, 0, 1, 2, 12, 7);
        RIPEMD160.III(nArray4, nArray2, 2, 3, 4, 0, 1, 4, 6);
        RIPEMD160.III(nArray4, nArray2, 1, 2, 3, 4, 0, 9, 15);
        RIPEMD160.III(nArray4, nArray2, 0, 1, 2, 3, 4, 1, 13);
        RIPEMD160.III(nArray4, nArray2, 4, 0, 1, 2, 3, 2, 11);
        RIPEMD160.HHH(nArray4, nArray2, 3, 4, 0, 1, 2, 15, 9);
        RIPEMD160.HHH(nArray4, nArray2, 2, 3, 4, 0, 1, 5, 7);
        RIPEMD160.HHH(nArray4, nArray2, 1, 2, 3, 4, 0, 1, 15);
        RIPEMD160.HHH(nArray4, nArray2, 0, 1, 2, 3, 4, 3, 11);
        RIPEMD160.HHH(nArray4, nArray2, 4, 0, 1, 2, 3, 7, 8);
        RIPEMD160.HHH(nArray4, nArray2, 3, 4, 0, 1, 2, 14, 6);
        RIPEMD160.HHH(nArray4, nArray2, 2, 3, 4, 0, 1, 6, 6);
        RIPEMD160.HHH(nArray4, nArray2, 1, 2, 3, 4, 0, 9, 14);
        RIPEMD160.HHH(nArray4, nArray2, 0, 1, 2, 3, 4, 11, 12);
        RIPEMD160.HHH(nArray4, nArray2, 4, 0, 1, 2, 3, 8, 13);
        RIPEMD160.HHH(nArray4, nArray2, 3, 4, 0, 1, 2, 12, 5);
        RIPEMD160.HHH(nArray4, nArray2, 2, 3, 4, 0, 1, 2, 14);
        RIPEMD160.HHH(nArray4, nArray2, 1, 2, 3, 4, 0, 10, 13);
        RIPEMD160.HHH(nArray4, nArray2, 0, 1, 2, 3, 4, 0, 13);
        RIPEMD160.HHH(nArray4, nArray2, 4, 0, 1, 2, 3, 4, 7);
        RIPEMD160.HHH(nArray4, nArray2, 3, 4, 0, 1, 2, 13, 5);
        RIPEMD160.GGG(nArray4, nArray2, 2, 3, 4, 0, 1, 8, 15);
        RIPEMD160.GGG(nArray4, nArray2, 1, 2, 3, 4, 0, 6, 5);
        RIPEMD160.GGG(nArray4, nArray2, 0, 1, 2, 3, 4, 4, 8);
        RIPEMD160.GGG(nArray4, nArray2, 4, 0, 1, 2, 3, 1, 11);
        RIPEMD160.GGG(nArray4, nArray2, 3, 4, 0, 1, 2, 3, 14);
        RIPEMD160.GGG(nArray4, nArray2, 2, 3, 4, 0, 1, 11, 14);
        RIPEMD160.GGG(nArray4, nArray2, 1, 2, 3, 4, 0, 15, 6);
        RIPEMD160.GGG(nArray4, nArray2, 0, 1, 2, 3, 4, 0, 14);
        RIPEMD160.GGG(nArray4, nArray2, 4, 0, 1, 2, 3, 5, 6);
        RIPEMD160.GGG(nArray4, nArray2, 3, 4, 0, 1, 2, 12, 9);
        RIPEMD160.GGG(nArray4, nArray2, 2, 3, 4, 0, 1, 2, 12);
        RIPEMD160.GGG(nArray4, nArray2, 1, 2, 3, 4, 0, 13, 9);
        RIPEMD160.GGG(nArray4, nArray2, 0, 1, 2, 3, 4, 9, 12);
        RIPEMD160.GGG(nArray4, nArray2, 4, 0, 1, 2, 3, 7, 5);
        RIPEMD160.GGG(nArray4, nArray2, 3, 4, 0, 1, 2, 10, 15);
        RIPEMD160.GGG(nArray4, nArray2, 2, 3, 4, 0, 1, 14, 8);
        RIPEMD160.FFF(nArray4, nArray2, 1, 2, 3, 4, 0, 12, 8);
        RIPEMD160.FFF(nArray4, nArray2, 0, 1, 2, 3, 4, 15, 5);
        RIPEMD160.FFF(nArray4, nArray2, 4, 0, 1, 2, 3, 10, 12);
        RIPEMD160.FFF(nArray4, nArray2, 3, 4, 0, 1, 2, 4, 9);
        RIPEMD160.FFF(nArray4, nArray2, 2, 3, 4, 0, 1, 1, 12);
        RIPEMD160.FFF(nArray4, nArray2, 1, 2, 3, 4, 0, 5, 5);
        RIPEMD160.FFF(nArray4, nArray2, 0, 1, 2, 3, 4, 8, 14);
        RIPEMD160.FFF(nArray4, nArray2, 4, 0, 1, 2, 3, 7, 6);
        RIPEMD160.FFF(nArray4, nArray2, 3, 4, 0, 1, 2, 6, 8);
        RIPEMD160.FFF(nArray4, nArray2, 2, 3, 4, 0, 1, 2, 13);
        RIPEMD160.FFF(nArray4, nArray2, 1, 2, 3, 4, 0, 13, 6);
        RIPEMD160.FFF(nArray4, nArray2, 0, 1, 2, 3, 4, 14, 5);
        RIPEMD160.FFF(nArray4, nArray2, 4, 0, 1, 2, 3, 0, 15);
        RIPEMD160.FFF(nArray4, nArray2, 3, 4, 0, 1, 2, 3, 13);
        RIPEMD160.FFF(nArray4, nArray2, 2, 3, 4, 0, 1, 9, 11);
        RIPEMD160.FFF(nArray4, nArray2, 1, 2, 3, 4, 0, 11, 11);
        nArray4[3] = nArray4[3] + (nArray3[2] + nArray[1]);
        nArray[1] = nArray[2] + nArray3[3] + nArray4[4];
        nArray[2] = nArray[3] + nArray3[4] + nArray4[0];
        nArray[3] = nArray[4] + nArray3[0] + nArray4[1];
        nArray[4] = nArray[0] + nArray3[1] + nArray4[2];
        nArray[0] = nArray4[3];
    }

    private void doReset() {
        this.inputBufferOffset = 0;
        this.plainTextLength = 0;
        this.mdBuffer[0] = 1732584193;
        this.mdBuffer[1] = -271733879;
        this.mdBuffer[2] = -1732584194;
        this.mdBuffer[3] = 271733878;
        this.mdBuffer[4] = -1009589776;
    }

    protected byte[] engineDigest() {
        int n;
        int n2 = 56 - (this.plainTextLength & 0x3F);
        int n3 = n2 > 0 ? n2 : 64 + n2;
        this.inputBuffer[this.inputBufferOffset] = -128;
        int n4 = 1;
        if (this.inputBufferOffset + n3 > 64) {
            n4 = 64 - this.inputBufferOffset;
            n = 1;
            while (n < n4) {
                this.inputBuffer[this.inputBufferOffset + n] = 0;
                ++n;
            }
            RIPEMD160.doDecodeBlock(this.mdBuffer, Bytes.bytesLSBToInts(this.inputBuffer, 0, 64));
            this.inputBufferOffset = -n4;
        }
        n = n4;
        while (n < n3) {
            this.inputBuffer[this.inputBufferOffset + n] = 0;
            ++n;
        }
        this.inputBufferOffset += n3;
        long l = this.plainTextLength * 8;
        int n5 = 0;
        while (n5 < 8) {
            this.inputBuffer[this.inputBufferOffset + n5] = (byte)(l >>> 8 * n5 & 0xFFL);
            ++n5;
        }
        RIPEMD160.doDecodeBlock(this.mdBuffer, Bytes.bytesLSBToInts(this.inputBuffer, 0, 64));
        byte[] byArray = Bytes.intsToBytesLSB(this.mdBuffer);
        this.doReset();
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 20) {
            throw new DigestException("Specified length too short for digest");
        }
        if (byArray.length - n < 20) {
            throw new DigestException("Buffer too short for digest");
        }
        byte[] byArray2 = this.engineDigest();
        System.arraycopy(byArray2, 0, byArray, n, 20);
        return 20;
    }

    protected int engineGetDigestLength() {
        return 20;
    }

    protected void engineReset() {
        this.doReset();
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2;
        int n5 = 0;
        while ((n3 = 64 - this.inputBufferOffset) <= n4) {
            System.arraycopy(byArray, n5 + n, this.inputBuffer, this.inputBufferOffset, n3);
            RIPEMD160.doDecodeBlock(this.mdBuffer, Bytes.bytesLSBToInts(this.inputBuffer, 0, 64));
            n4 -= n3;
            this.inputBufferOffset = 0;
            n5 += n3;
        }
        System.arraycopy(byArray, n5 + n, this.inputBuffer, 0, n4);
        this.inputBufferOffset += n4;
        this.plainTextLength += n2;
    }
}

