/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.Licensed;
import com.dstc.security.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class RSA
extends CipherSpi
implements Licensed {
    private static final byte PRIVATE_KEY_ENCRYPT_MODE = 1;
    private static final byte PUBLIC_KEY_ENCRYPT_MODE = 2;
    private RSAPublicKey rsaPubKey;
    private RSAPrivateKey rsaPrivKey;
    private RSAPrivateCrtKey rsaPrivCrtKey;
    private byte[] data;
    private SecureRandom random;
    private byte[] empty = new byte[0];
    private int state;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private PKCS1Padding pad;
    private int k;
    private byte pkcs1Mode = (byte)2;

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        this.engineUpdate(byArray, n, n2);
        this.data = this.bos.toByteArray();
        this.bos.reset();
        if (this.state == 1) {
            if (this.pkcs1Mode == 2) {
                if (this.data.length > this.k - 11) {
                    throw new IllegalBlockSizeException("Data too long for PKCS1 padding");
                }
                byArray2 = this.publicKeyOp(this.pad.doPadding(this.k, this.data));
            } else {
                byArray2 = this.privateCRTKeyOp(this.pad.doPadding(this.k, this.data));
            }
        } else if (this.state == 2) {
            try {
                byArray2 = this.pkcs1Mode == 2 ? this.pad.doUnPadding(this.k, this.privateCRTKeyOp(this.data)) : this.pad.doUnPadding(this.k, this.publicKeyOp(this.data));
            }
            catch (BadPaddingException badPaddingException) {
                throw new BadPaddingException("Decryption error :" + badPaddingException.getMessage());
            }
        }
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byArray2.length - n3 < this.engineGetOutputSize(n2)) {
            throw new ShortBufferException("Output Buffer too short");
        }
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int n) {
        if (this.state == 2) {
            return this.k;
        }
        if (this.state == 1) {
            return this.k;
        }
        throw new IllegalStateException("RSA Cipher not yet initialized");
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("No params needed for RSA");
        }
        this.engineInit(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.state = n;
        this.random = secureRandom;
        if (!key.getAlgorithm().equals("RSA")) {
            throw new InvalidKeyException("Not an RSA Key");
        }
        if (key instanceof RSAPublicKey) {
            this.rsaPubKey = (RSAPublicKey)key;
            this.k = this.rsaPubKey.getModulus().bitLength() + 7 >>> 3;
            this.pkcs1Mode = n == 2 ? (byte)1 : (byte)2;
        } else if (key instanceof PrivateKey) {
            this.pkcs1Mode = n == 2 ? (byte)2 : (byte)1;
            if (key instanceof RSAPrivateCrtKey) {
                this.rsaPrivCrtKey = (RSAPrivateCrtKey)key;
                this.k = this.rsaPrivCrtKey.getModulus().bitLength() + 7 >>> 3;
            } else if (key instanceof RSAPrivateKey) {
                this.rsaPrivKey = (RSAPrivateKey)key;
                this.k = this.rsaPrivKey.getModulus().bitLength() + 7 >>> 3;
            }
        } else {
            throw new InvalidKeyException("Cannot handle this key");
        }
        this.bos.reset();
        this.pad = new PKCS1Padding(this.pkcs1Mode);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No params needed for RSA");
        }
        this.engineInit(n, key, secureRandom);
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException(String.valueOf(string) + " Not supported");
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equals("PKCS1Padding")) {
            throw new NoSuchPaddingException(String.valueOf(string) + " Not supported");
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            this.bos.write(byArray, n, n2);
        }
        return this.empty;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (byArray != null) {
            this.bos.write(byArray, n, n2);
        }
        return 0;
    }

    private byte[] privateCRTKeyOp(byte[] byArray) {
        BigInteger bigInteger = this.rsaPrivCrtKey.getModulus();
        BigInteger bigInteger2 = this.rsaPrivCrtKey.getPrivateExponent();
        BigInteger bigInteger3 = this.rsaPrivCrtKey.getPrimeP();
        BigInteger bigInteger4 = this.rsaPrivCrtKey.getPrimeQ();
        BigInteger bigInteger5 = this.rsaPrivCrtKey.getPrimeExponentP();
        BigInteger bigInteger6 = this.rsaPrivCrtKey.getPrimeExponentQ();
        BigInteger bigInteger7 = this.rsaPrivCrtKey.getCrtCoefficient();
        BigInteger bigInteger8 = new BigInteger(1, byArray);
        BigInteger bigInteger9 = bigInteger8.modPow(bigInteger5, bigInteger3);
        BigInteger bigInteger10 = bigInteger8.modPow(bigInteger6, bigInteger4);
        BigInteger bigInteger11 = bigInteger9.subtract(bigInteger10).multiply(bigInteger7).mod(bigInteger3);
        BigInteger bigInteger12 = bigInteger11.multiply(bigInteger4).add(bigInteger10);
        return Bytes.removeLeadingZero(bigInteger12.toByteArray());
    }

    private byte[] privateKeyOp(byte[] byArray) {
        BigInteger bigInteger = this.rsaPrivKey.getModulus();
        BigInteger bigInteger2 = this.rsaPrivKey.getPrivateExponent();
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return Bytes.removeLeadingZero(bigInteger4.toByteArray());
    }

    private byte[] publicKeyOp(byte[] byArray) {
        BigInteger bigInteger = this.rsaPubKey.getModulus();
        BigInteger bigInteger2 = this.rsaPubKey.getPublicExponent();
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return Bytes.removeLeadingZero(bigInteger4.toByteArray());
    }

    protected class PKCS1Padding {
        private byte blockType;

        protected PKCS1Padding(byte by) {
            this.blockType = by;
        }

        protected byte[] doPadding(int n, byte[] byArray) {
            byte[] byArray2 = new byte[n];
            int n2 = n - 3 - byArray.length;
            byArray2[0] = 0;
            byArray2[1] = this.blockType;
            if (this.blockType == 1) {
                int n3 = 0;
                while (n3 < n2) {
                    byArray2[2 + n3] = -1;
                    ++n3;
                }
            } else if (this.blockType == 2) {
                byte[] byArray3 = new byte[n2];
                RSA.this.random.nextBytes(byArray3);
                int n4 = 0;
                while (n4 < byArray3.length) {
                    int n5 = n4++;
                    byArray3[n5] = (byte)(byArray3[n5] | 1);
                }
                System.arraycopy(byArray3, 0, byArray2, 2, byArray3.length);
            } else {
                throw new RuntimeException("Internal error: unsupported block type " + this.blockType);
            }
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
            return byArray2;
        }

        protected byte[] doUnPadding(int n, byte[] byArray) throws BadPaddingException {
            if (byArray[0] != this.blockType) {
                throw new BadPaddingException("Encountered block type: " + byArray[0] + " while expecting " + this.blockType);
            }
            int n2 = 2 - n + byArray.length;
            while (byArray[n2] != 0) {
                ++n2;
            }
            byte[] byArray2 = new byte[byArray.length - n2 - 1];
            System.arraycopy(byArray, n2 + 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
    }
}

