/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private Cipher cipher;
    private byte[] buffer;
    private int blockSize;
    private int bufferStart = 0;
    private int bufferLen = 0;
    private boolean eof = false;
    private byte[] buf;
    private byte[] cipherText;
    private byte[] temp;

    protected CipherInputStream(InputStream inputStream) {
        super(inputStream);
        this.cipher = new NullCipher();
        this.blockSize = this.cipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
        this.blockSize = cipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
    }

    public int available() throws IOException {
        try {
            return this.cipher.getOutputSize(this.in.available()) + this.bufferLen;
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean markSupported() {
        return false;
    }

    private int processMore(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            int n4;
            int n5;
            if (this.cipherText == null || this.cipherText.length < n2) {
                this.cipherText = new byte[n2];
            }
            if ((n5 = this.in.read(this.cipherText, 0, n2)) == -1) {
                this.eof = true;
                int n6 = this.cipher.doFinal(this.buf, 0);
                if (n2 < n6) {
                    System.arraycopy(this.buf, 0, byArray, n, n2);
                    this.bufferLen = n6 - n2;
                    System.arraycopy(this.buf, n2, this.buffer, 0, this.bufferLen);
                    return n3 += n2;
                }
                System.arraycopy(this.buf, 0, byArray, n, n6);
                return n3 += n6;
            }
            int n7 = this.cipher.getOutputSize(n5);
            if (this.temp == null || this.temp.length < n7) {
                this.temp = new byte[n7];
            }
            if (n2 < (n4 = this.cipher.update(this.cipherText, 0, n5, this.temp, 0))) {
                System.arraycopy(this.temp, 0, byArray, n, n2);
                this.bufferLen = n4 - n2;
                System.arraycopy(this.temp, n2, this.buffer, 0, this.bufferLen);
                return n3 += n2;
            }
            System.arraycopy(this.temp, 0, byArray, n, n4);
            this.bufferLen = 0;
            return n3 += n4;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException("Cipher in wrong state");
        }
        catch (ShortBufferException shortBufferException) {
            throw new IOException(shortBufferException.toString());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException(illegalBlockSizeException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.toString());
        }
    }

    public int read() throws IOException {
        int n;
        do {
            if ((n = this.read(this.buf, 0, 1)) != -1) continue;
            return -1;
        } while (n != 1);
        return this.buf[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eof && this.bufferLen == 0) {
            return -1;
        }
        int n3 = 0;
        if (n2 <= this.bufferLen) {
            System.arraycopy(this.buffer, this.bufferStart, byArray, n, n2);
            this.bufferStart += n2;
            this.bufferLen -= n2;
            return n3 += n2;
        }
        System.arraycopy(this.buffer, this.bufferStart, byArray, n, this.bufferLen);
        n3 += this.bufferLen;
        n += this.bufferLen;
        n2 -= this.bufferLen;
        this.bufferStart = 0;
        this.bufferLen = 0;
        if (this.eof) {
            return n3;
        }
        int n4 = 0;
        while (n4 == 0 && !this.eof) {
            n4 += this.processMore(byArray, n, n2);
        }
        if (this.eof && n3 + n4 == 0) {
            return -1;
        }
        return n3 + n4;
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        return this.read(byArray, 0, (int)l);
    }
}

