/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac {
    private MacSpi delegate;
    private Provider provider;
    private String algorithm;
    private int state;
    private static final int UNINITIALIZED = 0;
    private static final int INITIALIZED = 1;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.delegate = macSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return this.delegate.clone();
        }
        throw new CloneNotSupportedException();
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        return this.delegate.engineDoFinal();
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.update(byArray);
        return this.delegate.engineDoFinal();
    }

    public final void doFinal(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        if (byArray.length - n < this.getMacLength()) {
            throw new ShortBufferException("Buffer too short");
        }
        byte[] byArray2 = this.doFinal();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        Mac mac = null;
        int n = 0;
        while (n < providerArray.length) {
            try {
                mac = Mac.getInstance(string, providerArray[n].getName());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException("Internal error: " + noSuchProviderException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (mac != null) {
                return mac;
            }
            ++n;
        }
        throw new NoSuchAlgorithmException("Mac algorithm " + string + " not supported");
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new InvalidParameterException("Null provider is supplied");
        }
        try {
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string2 + " not found");
            }
            StringBuffer stringBuffer = new StringBuffer("Mac.");
            StringBuffer stringBuffer2 = new StringBuffer("Alg.Alias.Mac.");
            stringBuffer2.append(string);
            String string3 = Mac.getProviderProperty(stringBuffer2.toString(), provider);
            if (string3 != null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string);
            }
            String string4 = Mac.getProviderProperty(stringBuffer.toString(), provider);
            Class<?> clazz = Class.forName(string4);
            return new Mac((MacSpi)clazz.newInstance(), provider, string);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Mac algorithm " + string + " not found in provider " + string2);
        }
    }

    public final int getMacLength() {
        return this.delegate.engineGetMacLength();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = null;
        Enumeration enumeration = ((Hashtable)provider).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string3)) continue;
            string2 = ((Properties)provider).getProperty(string3);
            break;
        }
        return string2;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Need algorithm parameters to initialize");
        }
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = 1;
        this.delegate.engineInit(key, algorithmParameterSpec);
    }

    public final void reset() {
        this.delegate.engineReset();
    }

    public final void update(byte by) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.delegate.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.delegate.engineUpdate(byArray, n, n2);
    }
}

