/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.ClientKeyExchanger;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLSignature;
import com.dstc.security.ssl.V3Constants;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

class RSAClientKeyExchanger
implements ClientKeyExchanger {
    private final ClientHandShaker handShaker;
    private final SecureRandom rand;
    private final KeyFactory keyFact;
    private final Cipher rsa;
    private PublicKey serverKeyXKey;
    private byte[] protocolVersion = V3Constants.VERSION;

    RSAClientKeyExchanger(ClientHandShaker clientHandShaker, SecureRandom secureRandom) {
        this.handShaker = clientHandShaker;
        this.rand = secureRandom;
        try {
            this.keyFact = KeyFactory.getInstance("RSA");
            this.rsa = Cipher.getInstance("RSA");
        }
        catch (Exception exception) {
            throw new ProviderException(exception.getMessage());
        }
    }

    public byte[] getExchangeKeys() throws IOException {
        byte[] byArray = new byte[48];
        this.rand.nextBytes(byArray);
        System.arraycopy(this.protocolVersion, 0, byArray, 0, 2);
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("preMasterSecret: ", byArray);
        }
        this.handShaker.computeMasterSecret(byArray);
        try {
            this.rsa.init(1, this.serverKeyXKey);
            byte[] byArray2 = this.rsa.doFinal(byArray, 0, byArray.length);
            return byArray2;
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
    }

    public void setServerKey(PublicKey publicKey) {
        this.serverKeyXKey = (RSAPublicKey)publicKey;
    }

    public void setServerKey(byte[] byArray, int n) throws IOException {
        int n2 = n;
        int n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2 += 2, byArray2, 0, n3);
        n2 += n3;
        n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2 += 2, byArray3, 0, n3);
        int n4 = (n2 += n3) - n;
        n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n2 += 2, byArray4, 0, n3);
        try {
            this.serverKeyXKey = this.keyFact.generatePublic(new RSAPublicKeySpec(new BigInteger(1, byArray2), new BigInteger(1, byArray3)));
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
        try {
            SSLSignature sSLSignature = this.handShaker.getServerSignature();
            sSLSignature.setData(byArray, n, n4);
            if (!sSLSignature.verify(byArray4)) {
                throw new IOException("Bad server signature");
            }
        }
        catch (SignatureException signatureException) {
            throw new IOException(signatureException.getMessage());
        }
    }
}

