/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.common.SubjectPublicKeyInfo;
import com.dstc.security.common.X500Name;
import com.dstc.security.pki.CertificationRequest;
import com.dstc.security.pki.CertificationRequestInfo;
import com.dstc.security.pki.PKIException;
import com.dstc.security.util.Base64InputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Iterator;
import java.util.Set;

public class PKCS10CertificationRequest
implements CertificationRequest {
    private Asn1 asn1 = null;
    private CertificationRequestInfo crInfo;
    private String sigAlgName;
    private byte[] signature;
    private PublicKey pub;
    private static final byte TAG_SEQ_DER = 48;
    private static final String HDR = "-----BEGIN CERTIFICATION REQ";
    private static final String HDR2 = "-----BEGIN NEW CERTIFICATE REQ";
    private static final String FTR = "-----END";

    public PKCS10CertificationRequest(InputStream inputStream) throws PKIException {
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 20);
            int n = pushbackInputStream.read();
            if (n == 48) {
                pushbackInputStream.unread(n);
                this.initAsn1(Asn1.getAsn1(pushbackInputStream));
            } else {
                Object object;
                pushbackInputStream.unread(n);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(pushbackInputStream));
                String string = bufferedReader.readLine();
                if (!string.startsWith(HDR) && !string.startsWith(HDR2)) {
                    throw new PKIException("Invalid pkcs10 encoding");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
                while (!((String)(object = bufferedReader.readLine())).startsWith(FTR)) {
                    outputStreamWriter.write((String)object, 0, ((String)object).length());
                }
                outputStreamWriter.flush();
                object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                Base64InputStream base64InputStream = new Base64InputStream((InputStream)object);
                this.initAsn1(Asn1.getAsn1(base64InputStream));
            }
        }
        catch (IOException iOException) {
            throw new PKIException("Decoding error: nested exception is " + iOException.toString());
        }
    }

    public PKCS10CertificationRequest(String string, PublicKey publicKey, Set set, String string2, PrivateKey privateKey) throws PKIException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(publicKey.getEncoded());
            this.init(new CertificationRequestInfo(new X500Name(string), subjectPublicKeyInfo, set), string2, privateKey);
            this.pub = publicKey;
        }
        catch (Asn1Exception asn1Exception) {
            throw new PKIException();
        }
    }

    public PKCS10CertificationRequest(byte[] byArray) throws PKIException {
        this(new ByteArrayInputStream(byArray));
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    CertificationRequestInfo getCertificationRequestInfo() {
        return this.crInfo;
    }

    public byte[] getEncoded() {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            return null;
        }
    }

    public byte[] getEncodedPublicKey() {
        return this.crInfo.getSubjectPublicKeyInfo().getEncoded();
    }

    public String getKeyAlgName() {
        return this.crInfo.getKeyAlgName();
    }

    public PublicKey getPublicKey() {
        return this.pub;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getSubjectName() {
        return this.crInfo.getSubject().getName();
    }

    SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.crInfo.getSubjectPublicKeyInfo();
    }

    private void init(CertificationRequestInfo certificationRequestInfo, String string, PrivateKey privateKey) throws PKIException {
        this.asn1 = new Sequence();
        this.crInfo = certificationRequestInfo;
        this.asn1.add(certificationRequestInfo.getAsn1());
        this.sigAlgName = string;
        this.asn1.add(new AlgorithmId(OID.getAlgOid(string)).getAsn1());
        try {
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(certificationRequestInfo.getAsn1().getEncoded());
            this.signature = signature.sign();
            this.asn1.add(new BitString(this.signature));
        }
        catch (Exception exception) {
            throw new PKIException();
        }
    }

    private void initAsn1(Asn1 asn1) throws PKIException {
        AlgorithmId algorithmId = null;
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        try {
            this.crInfo = new CertificationRequestInfo((Asn1)iterator.next());
            KeyFactory keyFactory = KeyFactory.getInstance(this.crInfo.getKeyAlgName());
            this.pub = keyFactory.generatePublic(new X509EncodedKeySpec(this.crInfo.getSubjectPublicKeyInfo().getAsn1().getEncoded()));
            algorithmId = new AlgorithmId((Asn1)iterator.next());
        }
        catch (Exception exception) {
            throw new PKIException();
        }
        this.sigAlgName = OID.getAlgName(algorithmId.getOid());
        this.signature = ((BitString)iterator.next()).getBytes();
    }

    public boolean verifySignature() {
        try {
            Signature signature = Signature.getInstance(this.getSigAlgName());
            signature.initVerify(this.pub);
            signature.update(this.crInfo.getAsn1().getEncoded());
            return signature.verify(this.signature);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

