/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.PrivateKeyInfo;
import com.dstc.security.common.SubjectPublicKeyInfo;
import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.DHPublicKey;
import com.dstc.security.provider.Licensed;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DHKeyFactory
extends KeyFactorySpi
implements Licensed {
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHPrivateKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPrivateKeySpec) {
            DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)keySpec;
            return new DHPrivateKey(dHPrivateKeySpec.getX(), dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG());
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                AlgorithmId algorithmId = privateKeyInfo.getAlgorithmId();
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmId.getParams().getParameterSpec(class$javax$crypto$spec$DHParameterSpec != null ? class$javax$crypto$spec$DHParameterSpec : (class$javax$crypto$spec$DHParameterSpec = DHKeyFactory.class$("javax.crypto.spec.DHParameterSpec")));
                return new DHPrivateKey(privateKeyInfo.getEncodedKey(), dHParameterSpec);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("Bad key spec: " + exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("Not a DH private key spec");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPublicKeySpec) {
            DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)keySpec;
            return new DHPublicKey(dHPublicKeySpec.getY(), dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(((X509EncodedKeySpec)keySpec).getEncoded());
                AlgorithmId algorithmId = subjectPublicKeyInfo.getAlgorithmId();
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmId.getParams().getParameterSpec(class$javax$crypto$spec$DHParameterSpec != null ? class$javax$crypto$spec$DHParameterSpec : (class$javax$crypto$spec$DHParameterSpec = DHKeyFactory.class$("javax.crypto.spec.DHParameterSpec")));
                return new DHPublicKey(subjectPublicKeyInfo.getEncodedKey(), dHParameterSpec);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("Bad key spec: " + exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("Not a DH public key spec");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (!key.getAlgorithm().equals("DH")) {
            throw new InvalidKeySpecException("Not a DH key");
        }
        if (key instanceof PublicKey) {
            if (clazz.equals(class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = DHKeyFactory.class$("java.security.spec.X509EncodedKeySpec")))) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if (clazz.equals(class$javax$crypto$spec$DHPublicKeySpec != null ? class$javax$crypto$spec$DHPublicKeySpec : (class$javax$crypto$spec$DHPublicKeySpec = DHKeyFactory.class$("javax.crypto.spec.DHPublicKeySpec")))) {
                javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)key;
                return new DHPublicKeySpec(dHPublicKey.getY(), dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG());
            }
            throw new InvalidKeySpecException("Key and keySpec mismatch");
        }
        if (clazz.equals(class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = DHKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")))) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.equals(class$javax$crypto$spec$DHPrivateKeySpec != null ? class$javax$crypto$spec$DHPrivateKeySpec : (class$javax$crypto$spec$DHPrivateKeySpec = DHKeyFactory.class$("javax.crypto.spec.DHPrivateKeySpec")))) {
            javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)key;
            return new DHPrivateKeySpec(dHPrivateKey.getX(), dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG());
        }
        throw new InvalidKeySpecException("Key and keySpec mismatch");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            return null;
        }
        if (!key.getAlgorithm().equals("DH")) {
            throw new InvalidKeyException("Not a DH key");
        }
        if (key instanceof javax.crypto.interfaces.DHPublicKey) {
            javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)key;
            return new DHPublicKey(dHPublicKey.getY(), dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG());
        }
        if (key instanceof javax.crypto.interfaces.DHPrivateKey) {
            javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)key;
            return new DHPrivateKey(dHPrivateKey.getX(), dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG());
        }
        throw new InvalidKeyException("Cannot translate key");
    }
}

