/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DHKeyAgreement;
import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.ESDHParameterSpec;
import com.dstc.security.provider.KEKGenerator;
import com.dstc.security.provider.SymmetricKey;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class ESDHKeyAgreement
extends DHKeyAgreement {
    private AlgorithmParameterSpec aps = null;

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!bl) {
            throw new IllegalStateException("Only 2 parties supported for ESDH");
        }
        return super.engineDoPhase(key, bl);
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (!string.equals("3DESwrap") && !string.equals("RC2wrap")) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not suppported for Ephemeral-Static DH");
        }
        byte[] byArray = this.engineGenerateSecret();
        int n = string.equals("3DESwrap") ? 192 : 128;
        KEKGenerator kEKGenerator = new KEKGenerator(byArray, string, n);
        if (this.aps != null) {
            kEKGenerator.setPartyAInfo(((ESDHParameterSpec)this.aps).getPartyAInfo());
        }
        byte[] byArray2 = null;
        try {
            byArray2 = kEKGenerator.generateKeyMaterial();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
        SymmetricKey symmetricKey = string.equals("3DESwrap") ? new SymmetricKey("DESede", byArray2, 0, 24) : new SymmetricKey("RC2", byArray2, 0, 16);
        return symmetricKey;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Not a DH Private Key");
        }
        if (!(algorithmParameterSpec instanceof ESDHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Wrong type of parameters");
        }
        this.myPriv = (DHPrivateKey)key;
        this.modulus = this.myPriv.getParams().getP();
        this.base = this.myPriv.getParams().getG();
        this.aps = algorithmParameterSpec;
    }
}

