/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.Licensed;
import com.dstc.security.provider.RSAPrivateCrtKey;
import com.dstc.security.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;

public class RSAKeyPairGenerator
extends KeyPairGenerator
implements Licensed {
    private static BigInteger one = BigInteger.ONE;
    private static BigInteger two = BigInteger.valueOf(2L);
    private int modlen = 1024;
    private SecureRandom random;
    private static final int PROB = 80;
    private static final String EXPONENT = "10001";
    private static final int MAX_KEY_LENGTH = 8192;

    public RSAKeyPairGenerator() {
        super("RSA");
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        BigInteger bigInteger4 = new BigInteger(EXPONENT, 16);
        while ((bigInteger3 = (bigInteger2 = new BigInteger(this.modlen / 2, 80, this.random)).multiply(bigInteger = new BigInteger(this.modlen - this.modlen / 2, 80, this.random))).bitLength() != this.modlen) {
        }
        BigInteger bigInteger5 = bigInteger2.subtract(one).multiply(bigInteger.subtract(one));
        while (!bigInteger5.gcd(bigInteger4).equals(one)) {
            bigInteger2 = bigInteger2.subtract(two);
            bigInteger = bigInteger.subtract(two);
            bigInteger3 = bigInteger2.multiply(bigInteger);
            bigInteger5 = bigInteger2.subtract(one).multiply(bigInteger.subtract(one));
        }
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger5);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger3, bigInteger4);
        RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger3, bigInteger4, bigInteger6, bigInteger2, bigInteger);
        return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
    }

    public void initialize(int n) {
        if (n > 8192) {
            throw new InvalidParameterException("key length too long. Max = 8192 bits");
        }
        this.modlen = n;
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.initialize(n);
        this.random = secureRandom;
    }
}

