/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.provider.Licensed;
import com.dstc.security.provider.RSAPrivateCrtKey;
import com.dstc.security.provider.RSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public abstract class RSAwithAnyMD
extends SignatureSpi
implements Licensed {
    protected RSAPublicKey pubKey;
    protected RSAPrivateCrtKey privKey;
    protected MessageDigest md;
    protected String mdOid;
    protected ByteArrayOutputStream bos = new ByteArrayOutputStream();
    protected Cipher rsa;
    protected byte[] buf = new byte[1];

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        try {
            this.rsa = Cipher.getInstance("RSA");
            this.rsa.init(1, privateKey);
            this.bos.reset();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException("Internal error: " + noSuchPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal error: " + noSuchAlgorithmException.getMessage());
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            this.rsa = Cipher.getInstance("RSA");
            this.rsa.init(2, publicKey);
            this.bos.reset();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException("Internal error: " + noSuchPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal error: " + noSuchAlgorithmException.getMessage());
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No parameter to set for this algorithm");
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray;
        byte[] byArray2 = this.bos.toByteArray();
        if (byArray2.length == 0) {
            throw new SignatureException("Nothing to sign");
        }
        this.bos.reset();
        if (this.mdOid != null) {
            try {
                Sequence sequence = new Sequence();
                sequence.add(new AlgorithmId(this.mdOid, null).getAsn1());
                sequence.add(new OctetString(this.md.digest(byArray2)));
                byArray = sequence.getEncoded();
            }
            catch (Exception exception) {
                throw new RuntimeException("Internal error: " + exception.getMessage());
            }
        } else {
            byArray = byArray2;
        }
        try {
            return this.rsa.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("Internal error: " + badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("Internal error: " + illegalBlockSizeException.getMessage());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.buf[0] = by;
        this.engineUpdate(this.buf, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.bos.write(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4 = null;
        byte[] byArray5 = this.bos.toByteArray();
        if (byArray5.length == 0) {
            throw new SignatureException("Nothing to verify");
        }
        this.bos.reset();
        try {
            byArray4 = this.rsa.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            return false;
        }
        if (this.mdOid != null) {
            try {
                byArray3 = this.md.digest(byArray5);
                Asn1 asn1 = Asn1.getAsn1(byArray4);
                Iterator iterator = asn1.components();
                AlgorithmId algorithmId = new AlgorithmId((Asn1)iterator.next());
                byArray2 = ((OctetString)iterator.next()).getBytes();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            byArray3 = byArray5;
            byArray2 = byArray4;
        }
        return Arrays.equals(byArray3, byArray2);
    }
}

