/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.Licensed;
import com.dstc.security.provider.SymmetricKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

abstract class SymmKeyGenerator
extends KeyGeneratorSpi
implements Licensed {
    protected int keyLength;
    protected SecureRandom random;
    protected String alg;

    SymmKeyGenerator() {
    }

    protected SecretKey engineGenerateKey() {
        byte[] byArray = new byte[this.keyLength / 8];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray);
        return new SymmetricKey(this.alg, byArray);
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.keyLength = n;
        this.random = secureRandom;
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Params not supported");
    }
}

