/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    private byte[] sealedContents;
    private String alg;
    private AlgorithmParameters params = null;

    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException, BadPaddingException {
        this.alg = cipher.getAlgorithm();
        this.params = cipher.getParameters();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        this.sealedContents = cipher.doFinal(byteArrayOutputStream.toByteArray());
    }

    public final String getAlgorithm() {
        return this.alg;
    }

    private Object getObj(Cipher cipher) throws IOException, ClassNotFoundException, InvalidKeyException {
        try {
            return this.getObject(cipher);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Decryption failed");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("Decryption failed");
        }
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.alg);
            cipher.init(2, key, this.params);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException("Padding algorithm unavailable");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Algorithm and parameter mismatch");
        }
        return this.getObj(cipher);
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.alg, string);
            cipher.init(2, key, this.params);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException("Padding algorithm unavailable");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Algorithm and parameter mismatch");
        }
        return this.getObj(cipher);
    }

    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cipher.doFinal(this.sealedContents));
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }
}

