/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.pki.PKCS10CertificationRequest;
import com.dstc.security.pki.PKIException;
import com.dstc.security.util.Base64InputStream;
import com.dstc.security.util.Base64OutputStream;
import com.dstc.security.util.DegeneratePKCS7;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class CertUtil {
    static final String X509_HDR = "-----BEGIN CERTIFICATE-----\n";
    static final String X509_FTR = "\n-----END CERTIFICATE-----\n";
    static final String PKCS10_HDR = "-----BEGIN NEW CERTIFICATE REQUEST-----\n";
    static final String PKCS10_FTR = "\n-----END NEW CERTIFICATE REQUEST-----\n";
    static final String PKCS7_HDR = "-----BEGIN PKCS7-----\n";
    static final String PKCS7_FTR = "\n-----END PKCS7-----\n";

    private CertUtil() {
    }

    public static byte[] base64Decode(byte[] byArray) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Base64InputStream base64InputStream = new Base64InputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[128];
        while ((n = base64InputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] base64Encode(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
        base64OutputStream.write(byArray);
        base64OutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] encode(X509CRL[] x509CRLArray) throws PKIException {
        Vector<X509CRL> vector = new Vector<X509CRL>(x509CRLArray.length);
        try {
            int n = 0;
            while (n < x509CRLArray.length) {
                vector.add(x509CRLArray[n]);
                ++n;
            }
            return new DegeneratePKCS7(null, vector).getEncoded();
        }
        catch (Exception exception) {
            throw new PKIException("Encoding error: nested exception is " + exception.toString());
        }
    }

    public static byte[] encode(X509Certificate[] x509CertificateArray) throws PKIException {
        Vector<X509Certificate> vector = new Vector<X509Certificate>(x509CertificateArray.length);
        try {
            int n = 0;
            while (n < x509CertificateArray.length) {
                vector.add(x509CertificateArray[n]);
                ++n;
            }
            return new DegeneratePKCS7(vector, null).getEncoded();
        }
        catch (Exception exception) {
            throw new PKIException("Encoding error: nested exception is " + exception.toString());
        }
    }

    public static byte[] toPEMEncoding(PKCS10CertificationRequest pKCS10CertificationRequest) throws PKIException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(PKCS10_HDR.getBytes());
            byteArrayOutputStream.write(CertUtil.base64Encode(pKCS10CertificationRequest.getEncoded()));
            byteArrayOutputStream.write(PKCS10_FTR.getBytes());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKIException("Encoding error : nested exception is " + iOException.toString());
        }
    }

    public static byte[] toPEMEncoding(X509Certificate x509Certificate) throws PKIException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(X509_HDR.getBytes());
            byteArrayOutputStream.write(CertUtil.base64Encode(x509Certificate.getEncoded()));
            byteArrayOutputStream.write(X509_FTR.getBytes());
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new PKIException("Encoding error : nested exception is " + exception.toString());
        }
    }

    public static byte[] toPEMEncoding(X509CRL[] x509CRLArray) throws PKIException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(PKCS7_HDR.getBytes());
            byteArrayOutputStream.write(CertUtil.base64Encode(CertUtil.encode(x509CRLArray)));
            byteArrayOutputStream.write(PKCS7_FTR.getBytes());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKIException("Unexpected error : nested exception is " + iOException.toString());
        }
    }

    public static byte[] toPEMEncoding(X509Certificate[] x509CertificateArray) throws PKIException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(PKCS7_HDR.getBytes());
            byteArrayOutputStream.write(CertUtil.base64Encode(CertUtil.encode(x509CertificateArray)));
            byteArrayOutputStream.write(PKCS7_FTR.getBytes());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKIException("Unexpected error : nested exception is " + iOException.toString());
        }
    }
}

