/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.V3Message;
import java.io.IOException;

final class Alert
extends V3Message {
    static final byte CLOSE_NOTIFY = 0;
    static final byte UNEXPECTED_MESSAGE = 10;
    static final byte BAD_RECORD_MAC = 20;
    static final byte DECOMPRESSION_FAILURE = 30;
    static final byte HANDSHAKE_FAILURE = 40;
    static final byte NO_CERTIFICATE = 41;
    static final byte BAD_CERTIFICATE = 42;
    static final byte UNSUPPORTED_CERTIFICATE = 43;
    static final byte CERTIFICATE_REVOKED = 44;
    static final byte CERTIFICATE_EXPIRED = 45;
    static final byte CERTIFICATE_UNKNOWN = 46;
    static final byte ILLEGAL_PARAMETER = 47;
    static final byte WARNING = 1;
    static final byte FATAL = 2;
    private byte level;
    private byte description;

    Alert() {
        this.contentType = (byte)21;
    }

    byte getDescription() {
        return this.description;
    }

    boolean isFatal() {
        return this.level == 2;
    }

    void refresh(byte[] byArray, int n, int n2) throws IOException {
        this.level = byArray[n];
        this.description = byArray[n + 1];
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("  **** Alert ****");
            com.dstc.security.util.Debug.debug("level: " + this.level);
            com.dstc.security.util.Debug.debug("description: " + this.description);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Alert: level = ");
        if (this.level == 1) {
            stringBuffer.append("WARNING");
        } else {
            stringBuffer.append("FATAL");
        }
        stringBuffer.append(" description = ");
        if (this.description == 40) {
            stringBuffer.append("Handshake failure");
        } else if (this.description == 10) {
            stringBuffer.append("Unexpected mesage");
        } else if (this.description == 0) {
            stringBuffer.append("Close notify");
        } else if (this.description == 20) {
            stringBuffer.append("Bad record mac");
        } else if (this.description == 41) {
            stringBuffer.append("No certificate");
        } else if (this.description == 45) {
            stringBuffer.append("Certificate expired");
        } else if (this.description == 44) {
            stringBuffer.append("Certificate revoked");
        } else if (this.description == 42) {
            stringBuffer.append("Bad certificate");
        } else {
            stringBuffer.append(this.description);
        }
        return stringBuffer.toString();
    }
}

