/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.ServerKeyExchanger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.net.ssl.SSLException;

class RSAServerKeyExchanger
implements ServerKeyExchanger {
    private final ServerHandShaker handShaker;
    private final SecureRandom rand;
    private final KeyPairGenerator kpg;
    private final Cipher rsa;
    private RSAPrivateKey serverKeyXKey;
    private int pubKeyBitLength;

    RSAServerKeyExchanger(ServerHandShaker serverHandShaker, SecureRandom secureRandom, PrivateKey privateKey) {
        this.handShaker = serverHandShaker;
        this.rand = secureRandom;
        this.setServerKey(privateKey);
        try {
            this.kpg = KeyPairGenerator.getInstance("RSA");
            this.rsa = Cipher.getInstance("RSA");
        }
        catch (Exception exception) {
            throw new ProviderException(exception.getMessage());
        }
    }

    protected KeyPair generateTempRSAPubKey(int n) throws IOException {
        try {
            this.kpg.initialize(n, this.rand);
            return ((KeyPairGeneratorSpi)this.kpg).generateKeyPair();
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
    }

    public byte[] getPreMasterSecret(byte[] byArray, int n, PublicKey publicKey) throws IOException {
        int n2 = this.pubKeyBitLength + 7 >>> 3;
        try {
            this.rsa.init(2, this.serverKeyXKey);
            if (byArray.length < n + n2) {
                byte[] byArray2 = new byte[n + n2];
                System.arraycopy(byArray, n, byArray2, 2 * n + n2 - byArray.length, byArray.length - n);
                return this.rsa.doFinal(byArray2, n, n2);
            }
            return this.rsa.doFinal(byArray, n, n2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSLException(invalidKeyException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new SSLException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SSLException(illegalBlockSizeException.getMessage());
        }
    }

    public byte[] getServerKey(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        KeyPair keyPair = this.generateTempRSAPubKey(n);
        this.setServerKey(keyPair.getPrivate());
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        byte[] byArray = rSAPublicKey.getModulus().toByteArray();
        byte[] byArray2 = rSAPublicKey.getPublicExponent().toByteArray();
        byteArrayOutputStream.write((byte)(byArray.length >> 8));
        byteArrayOutputStream.write((byte)byArray.length);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write((byte)(byArray2.length >> 8));
        byteArrayOutputStream.write((byte)byArray2.length);
        byteArrayOutputStream.write(byArray2);
        try {
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            this.handShaker.getServerSignature().setData(byArray3, 0, byArray3.length);
            byte[] byArray4 = this.handShaker.getServerSignature().sign();
            byteArrayOutputStream.write((byte)(byArray4.length >> 8 & 0xFF));
            byteArrayOutputStream.write((byte)(byArray4.length & 0xFF));
            byteArrayOutputStream.write(byArray4);
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException("Internal error: " + signatureException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void setServerKey(PrivateKey privateKey) {
        this.serverKeyXKey = (RSAPrivateKey)privateKey;
        this.pubKeyBitLength = this.serverKeyXKey.getModulus().bitLength();
    }
}

