/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Set;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

final class CRLSet {
    private Asn1 asn1 = null;
    private Vector crls;

    CRLSet(Asn1 asn1) throws Asn1Exception, CRLException {
        CertificateFactory certificateFactory;
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        this.crls = new Vector();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 == null) break;
            this.crls.add(certificateFactory.generateCRL(new ByteArrayInputStream(asn12.getEncoded())));
        }
    }

    CRLSet(Vector vector) throws Asn1Exception, IOException, CRLException {
        this.asn1 = new Set();
        this.crls = vector;
        Iterator iterator = ((AbstractList)this.crls).iterator();
        while (iterator.hasNext()) {
            Asn1 asn1 = Asn1.getAsn1(((X509CRL)iterator.next()).getEncoded());
            this.asn1.add(asn1);
        }
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    Vector getCRLs() {
        return this.crls;
    }
}

