/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Set;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;

final class CertificateSet {
    private Asn1 asn1 = null;
    private X509Certificate[] certs;

    CertificateSet(Asn1 asn1) throws Asn1Exception, CertificateException {
        CertificateFactory certificateFactory;
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 == null) break;
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(asn12.getEncoded()));
            vector.add(x509Certificate);
        }
        this.certs = new X509Certificate[vector.size()];
        vector.toArray(this.certs);
    }

    CertificateSet(X509Certificate[] x509CertificateArray) throws Asn1Exception, IOException, CertificateException {
        this.asn1 = new Set();
        this.certs = x509CertificateArray;
        int n = 0;
        while (n < x509CertificateArray.length) {
            Asn1 asn1 = Asn1.getAsn1(x509CertificateArray[n].getEncoded());
            this.asn1.add(asn1);
            ++n;
        }
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    X509Certificate[] getCerts() {
        return this.certs;
    }
}

