/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import com.dstc.security.certpath.CertPathException;
import com.dstc.security.cms.BEREncodedInputStream;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.CMSTypedDataInputStream;
import com.dstc.security.cms.CRLSet;
import com.dstc.security.cms.CertificateSet;
import com.dstc.security.cms.ContentTypeImpl;
import com.dstc.security.cms.DigestInputStream;
import com.dstc.security.cms.DigestsInputStream;
import com.dstc.security.cms.EncapContentInfo;
import com.dstc.security.cms.SignedData;
import com.dstc.security.cms.Signer;
import com.dstc.security.cms.SignerInfo;
import com.dstc.security.cms.TwoInputStream;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.x509.X509ExtensionUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

class SignedDataImpl
implements SignedData {
    private Asn1 outer = null;
    private int version = 1;
    private Vector digestAlgorithms = null;
    private byte[][] digests;
    private EncapContentInfo eContentInfo = null;
    private X509Certificate[] certs = null;
    private Vector crls = null;
    private Vector signerInfos = null;
    private ByteArrayOutputStream os = null;
    private boolean useSignedAtts = true;
    private int contentType = 0;
    private Iterator it = null;
    private Vector trusted = null;
    private Vector totalCerts = null;
    private DigestsInputStream dis = null;
    private TwoInputStream verStream = null;
    private boolean isVerified = false;

    SignedDataImpl(InputStream inputStream, Vector vector, Vector vector2, InputStream inputStream2) throws Asn1Exception, IOException, CMSException {
        this.decode(Asn1.getAsn1(inputStream), vector, vector2, inputStream2);
    }

    SignedDataImpl(PrivateKey privateKey, X509Certificate[] x509CertificateArray, String string, boolean bl, CMSTypedDataInputStream cMSTypedDataInputStream) throws CMSException {
        try {
            String string2 = System.getProperty("jcsi.cms.nosignedatts");
            if (string2 != null && string2.equals("true")) {
                this.useSignedAtts = false;
            }
            if (!X509ExtensionUtil.isKeyUsageSigning(x509CertificateArray[0])) {
                throw new CMSException("Certificate key usage does not include signing");
            }
            int n = cMSTypedDataInputStream.getCMSDataType();
            this.outer = new Sequence();
            this.outer.add(new Oid("1.2.840.113549.1.7.2"));
            Sequence sequence = new Sequence();
            if (n != 0) {
                this.version = 3;
                this.useSignedAtts = true;
            }
            sequence.add(new Integer(this.version));
            Set set = new Set();
            set.add(new AlgorithmId(OID.getAlgOid(string)).getAsn1());
            sequence.add(set);
            Set set2 = null;
            if (this.useSignedAtts) {
                set2 = new Set();
                set2.add(new ContentTypeImpl(cMSTypedDataInputStream.getContentType()).getAsn1());
            }
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            Signer signer = new Signer(privateKey, x509CertificateArray[0], string, set2);
            DigestInputStream digestInputStream = new DigestInputStream(cMSTypedDataInputStream, messageDigest, set2, signer);
            EncapContentInfo encapContentInfo = new EncapContentInfo(cMSTypedDataInputStream.getContentType(), bl ? digestInputStream : null);
            sequence.add(encapContentInfo.getAsn1());
            CertificateSet certificateSet = new CertificateSet(x509CertificateArray);
            Asn1 asn1 = certificateSet.getAsn1();
            asn1.setTagClass(128);
            asn1.setTagNumber(0);
            sequence.add(asn1);
            Set set3 = new Set();
            set3.add(signer.getAsn1());
            sequence.add(set3);
            Explicit explicit = new Explicit(128, 0);
            explicit.add(sequence);
            this.outer.add(explicit);
            if (!bl) {
                byte[] byArray = new byte[256];
                while (digestInputStream.read(byArray) != -1) {
                }
            }
        }
        catch (CMSException cMSException) {
            throw cMSException;
        }
        catch (Exception exception) {
            throw new CMSException("signing error: nested message is " + exception.toString());
        }
    }

    private void decode(Asn1 asn1, Vector vector, Vector vector2, InputStream inputStream) throws Asn1Exception, IOException, CMSException {
        String[] stringArray;
        if (vector2 == null) {
            throw new CMSException("No trusted certs set");
        }
        this.trusted = vector2;
        this.outer = asn1;
        Iterator iterator = asn1.components();
        if (iterator == null || !iterator.hasNext()) {
            throw new CMSException("Bad SignedData encoding");
        }
        if (!((Oid)iterator.next()).getOid().equals("1.2.840.113549.1.7.2")) {
            throw new CMSException("Not a SignedData encoding");
        }
        Asn1 asn12 = (Asn1)((Asn1)iterator.next()).components().next();
        this.it = asn12.components();
        this.version = ((Integer)this.it.next()).getInt();
        this.digestAlgorithms = new Vector();
        Set set = (Set)this.it.next();
        Iterator iterator2 = set.components();
        while (iterator2.hasNext()) {
            stringArray = (String[])iterator2.next();
            if (stringArray == null) break;
            this.digestAlgorithms.add(OID.getAlgName(new AlgorithmId((Asn1)stringArray).getOid()));
        }
        stringArray = new String[this.digestAlgorithms.size()];
        this.digestAlgorithms.toArray(stringArray);
        this.eContentInfo = new EncapContentInfo((Asn1)this.it.next());
        if (this.eContentInfo.getContentType().equals("1.2.840.113549.1.7.1")) {
            this.contentType = 0;
        } else if (this.eContentInfo.getContentType().equals("1.2.840.113549.1.7.2")) {
            this.contentType = 1;
        } else if (this.eContentInfo.getContentType().equals("1.2.840.113549.1.7.3")) {
            this.contentType = 2;
        } else {
            throw new CMSException("Content type " + this.eContentInfo.getContentType() + " unsupported for CMS signing");
        }
        if (this.eContentInfo.hasContent()) {
            this.dis = new DigestsInputStream(this, this.eContentInfo.getContent(), stringArray);
        } else {
            if (inputStream == null) {
                throw new CMSException("Cannot verify SignedData : No data encapsulated & no message provided");
            }
            this.dis = new DigestsInputStream(this, inputStream, stringArray);
        }
        this.totalCerts = vector != null ? vector : new Vector();
        this.verStream = new TwoInputStream(this.dis, null);
    }

    public int getCMSVersion() {
        return this.version;
    }

    public X509CRL[] getCRLs() {
        if (this.crls == null) {
            return null;
        }
        X509CRL[] x509CRLArray = new X509CRL[this.crls.size()];
        this.crls.toArray(x509CRLArray);
        return x509CRLArray;
    }

    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    public String[] getDigestAlgorithms() {
        String[] stringArray = new String[this.digestAlgorithms.size()];
        this.digestAlgorithms.toArray(stringArray);
        return stringArray;
    }

    int getEncapsulatedContentType() {
        return this.contentType;
    }

    CMSTypedDataInputStream getSigned() {
        return new CMSTypedDataInputStream(1, new BEREncodedInputStream(this.outer));
    }

    public SignerInfo[] getSignerInfos() {
        if (this.signerInfos == null) {
            return null;
        }
        SignerInfo[] signerInfoArray = new SignerInfo[this.signerInfos.size()];
        this.signerInfos.toArray(signerInfoArray);
        return signerInfoArray;
    }

    public TwoInputStream getVerified() {
        return this.verStream;
    }

    boolean isVerified() {
        return this.isVerified;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SignedData");
        stringBuffer.append("\n[");
        stringBuffer.append("\n  version: " + this.version);
        stringBuffer.append("\n  Digest algos: " + this.digestAlgorithms);
        stringBuffer.append("\n  SignerInfos ");
        if (this.signerInfos == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("{no of signers = ");
        stringBuffer.append(String.valueOf(this.signerInfos.size()));
        stringBuffer.append("}");
        stringBuffer.append("\n  [");
        int n = 0;
        while (n < this.signerInfos.size()) {
            StringTokenizer stringTokenizer = new StringTokenizer(((SignerInfo)this.signerInfos.elementAt(n)).toString(), "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("\n     ").append(stringTokenizer.nextToken());
            }
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("  ]");
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    void verifyAllSigners() throws Asn1Exception, IOException, CRLException, CertificateException, CMSException, CertPathException {
        Asn1 asn1 = (Asn1)this.it.next();
        if (asn1.getTagNumber() == 0) {
            this.certs = new CertificateSet(asn1).getCerts();
            asn1 = (Asn1)this.it.next();
        }
        if (asn1.getTagNumber() == 1) {
            this.crls = new CRLSet(asn1).getCRLs();
            asn1 = (Asn1)this.it.next();
        }
        if (this.certs != null) {
            int n = 0;
            while (n < this.certs.length) {
                this.totalCerts.add(this.certs[n]);
                ++n;
            }
        }
        this.signerInfos = new Vector();
        Set set = (Set)asn1;
        Iterator iterator = set.components();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 == null) break;
            this.signerInfos.add(new Signer(asn12, this.totalCerts, this.trusted, this.dis));
        }
        this.isVerified = true;
    }
}

