/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.cms.EnvelopedData;
import com.dstc.security.smime.DecryptionResult;
import com.dstc.security.smime.SMIMEException;
import com.dstc.security.smime.SMIMEPart;
import com.dstc.security.smime.SMIMEUtil;
import com.dstc.security.smime.handlers.EncryptedContent;
import com.dstc.security.smime.handlers.SignedContent;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMIMECipher {
    private static final int UNINITIALIZED = 0;
    private static final int ENCRYPT_MODE = 1;
    private static final int DECRYPT_MODE = 2;
    private MimeMessage msg;
    private int mode;
    private SMIMEPart encPart;
    private String encryptionAlg;
    private X509Certificate[] certs;
    private SecureRandom rand;

    public SMIMECipher() {
        String string = System.getProperty("jcsi.smime.usemailcap");
        if (string == null || !string.equals("true")) {
            SMIMEUtil.setupMailcap();
        }
    }

    public DecryptionResult decrypt() throws IOException, MessagingException, SMIMEException {
        Object var1_1 = null;
        if (this.mode != 2) {
            throw new SMIMEException("Not initialized for decryption");
        }
        if (this.msg == null) {
            throw new SMIMEException("Mime message not set");
        }
        this.encPart.setContent(this.msg.getContent(), this.msg.getContentType());
        com.dstc.security.cms.DecryptionResult decryptionResult = this.encPart.decrypt();
        this.msg.removeHeader("Content-Type");
        this.msg.removeHeader("Content-Transfer-Encoding");
        this.msg.removeHeader("Content-Description");
        this.msg.removeHeader("Content-Disposition");
        MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)decryptionResult.getDecrypted());
        if (mimeBodyPart.getContentType().startsWith("application/x-pkcs7-mime; smime-type=signed-data")) {
            this.msg.setContent((Object)new SignedContent((InputStream)mimeBodyPart.getContent()), mimeBodyPart.getContentType());
        } else if (mimeBodyPart.getContentType().startsWith("application/x-pkcs7-mime; smime-type=enveloped-data")) {
            this.msg.setContent((Object)new EncryptedContent((InputStream)mimeBodyPart.getContent()), mimeBodyPart.getContentType());
        } else {
            this.msg.setContent(mimeBodyPart.getContent(), mimeBodyPart.getContentType());
        }
        Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
        while (enumeration.hasMoreElements()) {
            this.msg.addHeaderLine((String)enumeration.nextElement());
        }
        this.msg.saveChanges();
        return new DecResult(this.msg, decryptionResult.getCMSEnvelopedData());
    }

    public MimeMessage encrypt() throws SMIMEException, MessagingException, IOException {
        if (this.mode != 1) {
            throw new SMIMEException("Not initialized for encryption");
        }
        if (this.msg == null) {
            throw new SMIMEException("Mime message not set");
        }
        this.encPart.setEncryptionAlgorithm(this.encryptionAlg);
        this.encPart.setRecipients(this.certs);
        this.encPart.encrypt();
        this.msg.setContent(this.encPart.getContent(), "application/x-pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"");
        this.msg.setHeader("Content-Transfer-Encoding", "base64");
        this.msg.setHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
        this.msg.setHeader("Content-Description", "S/MIME Encrypted Message");
        this.msg.saveChanges();
        return this.msg;
    }

    public void initDecrypt(PrivateKey privateKey, X509Certificate x509Certificate) throws SMIMEException {
        this.encPart = new SMIMEPart(privateKey, x509Certificate);
        this.mode = 2;
    }

    public void initEncrypt(SecureRandom secureRandom, String string, X509Certificate[] x509CertificateArray) throws SMIMEException {
        this.rand = secureRandom == null ? new SecureRandom() : secureRandom;
        this.mode = 1;
        this.encryptionAlg = string;
        this.certs = x509CertificateArray;
    }

    public void setMessage(MimeMessage mimeMessage) throws MessagingException, IOException, SMIMEException {
        if (this.mode == 0) {
            throw new SMIMEException("SMIMECipher not yet initialized");
        }
        this.msg = new MimeMessage(mimeMessage);
        if (this.mode != 1) {
            if (!SMIMEUtil.isEncrypted(mimeMessage)) {
                throw new SMIMEException("Not an encrypted message");
            }
            this.msg = new MimeMessage(mimeMessage);
            return;
        }
        if (this.msg.getContentType().startsWith("multipart")) {
            MimeMultipart mimeMultipart = (MimeMultipart)this.msg.getContent();
            this.encPart = new SMIMEPart((Multipart)mimeMultipart, this.rand);
        } else {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent(this.msg.getContent(), this.msg.getContentType());
            mimeBodyPart.setHeader("Content-Type", this.msg.getContentType());
            mimeBodyPart.setHeader("Content-Transfer-Encoding", this.msg.getEncoding());
            mimeBodyPart.setDisposition(this.msg.getDisposition());
            mimeBodyPart.setDescription(this.msg.getDescription());
            this.encPart = new SMIMEPart(mimeBodyPart, this.rand);
        }
        this.msg.setDisposition(null);
        this.msg.setDescription(null);
        this.msg.removeHeader("Content-Type");
        this.msg.removeHeader("Content-Transfer-Encoding");
    }

    class DecResult
    implements DecryptionResult {
        private MimeMessage msg;
        private EnvelopedData ed;

        DecResult(MimeMessage mimeMessage, EnvelopedData envelopedData) {
            this.msg = mimeMessage;
            this.ed = envelopedData;
        }

        public EnvelopedData getCMSEnvelopedData() {
            return this.ed;
        }

        public MimeMessage getMessage() {
            return this.msg;
        }
    }
}

