/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime.handlers;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.CMSSignature;
import com.dstc.security.cms.CMSTypedDataInputStream;
import com.dstc.security.cms.VerificationResult;
import com.dstc.security.smime.SMIMEException;
import com.dstc.security.smime.handlers.SignedContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class MimeMultipartSigned
extends MimeMultipart {
    private static final String CONTENT_TYPE_HDR = "Content-Type";
    private static final String CONTENT_DESCRIPTION_HDR = "Content-Description";
    private static final String CONTENT_DISPOSITION_HDR = "Content-Disposition";
    private static final String CONTENT_TRANSFER_ENCODING_HDR = "Content-Transfer-Encoding";
    private static final byte[] LINE_END = "\r\n".getBytes();
    private static final String SIG = "application/x-pkcs7-signature";
    private static final String B64 = "base64";
    private static final String P7S = "\"smime.p7s\"";
    private static final String SIG_P7S = "application/x-pkcs7-signature; name=\"smime.p7s\"";
    private static final String ATTACH_P7S = "attachment; filename=\"smime.p7s\"";
    private static final String MICALG = "micalg";
    private static final String SHA1 = "sha1";
    private static final String MD5 = "md5";
    private MimeBodyPart firstPart;
    private MimeBodyPart sigPart;
    private String digestAlg;
    private PrivateKey privateKey;
    private Vector trusted;
    private X509Certificate[] certs;
    private X509Certificate signerCert;
    private CMSSignature cmsSignature;
    private Vector certStore;

    MimeMultipartSigned(DataSource dataSource) throws IOException, MessagingException, CMSException {
        super(dataSource);
        this.firstPart = (MimeBodyPart)this.getBodyPart(0);
        this.sigPart = (MimeBodyPart)this.getBodyPart(1);
        if (!this.sigPart.isMimeType(SIG)) {
            throw new MessagingException("Bad mime part");
        }
    }

    public MimeMultipartSigned(Multipart multipart) throws MessagingException, IOException {
        super("signed; protocol=\"application/x-pkcs7-signature\"");
        this.firstPart = new MimeBodyPart();
        this.firstPart.setContent((Object)multipart, multipart.getContentType());
        this.firstPart.addHeader(CONTENT_TYPE_HDR, multipart.getContentType());
        this.addBodyPart((BodyPart)this.firstPart);
    }

    public MimeMultipartSigned(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        super("signed; protocol=\"application/x-pkcs7-signature\"");
        this.firstPart = mimeBodyPart;
        this.addBodyPart((BodyPart)mimeBodyPart);
    }

    private InputStream getMessageStream(MimeBodyPart mimeBodyPart) throws IOException, MessagingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
        if (mimeBodyPart.isMimeType("text/*")) {
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            InternetHeaders internetHeaders = new InternetHeaders((InputStream)byteArrayInputStream);
            Enumeration enumeration = internetHeaders.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                byteArrayOutputStream2.write(((String)enumeration.nextElement()).getBytes());
                byteArrayOutputStream2.write(LINE_END);
            }
            byteArrayOutputStream2.write(LINE_END);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byteArrayOutputStream2.toByteArray()), new CanonInputStream(byteArrayInputStream));
            return sequenceInputStream;
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public void setCertStore(Vector vector) {
        this.certStore = vector;
    }

    public void setDigestAlgorithm(String string) throws SMIMEException, MessagingException {
        this.digestAlg = string;
        if (string.equals("SHA-1")) {
            this.setSubType("signed; micalg=sha1");
        } else if (string.equals("MD5")) {
            this.setSubType("signed; micalg=md5");
        } else {
            throw new SMIMEException("Unsupported digest alg: " + string);
        }
    }

    public void setKeys(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.privateKey = privateKey;
        this.certs = x509CertificateArray;
    }

    public void setTrustedCAs(Vector vector) {
        this.trusted = vector;
    }

    public void sign() throws SMIMEException {
        if (this.digestAlg == null) {
            throw new SMIMEException("Digest algorithm not set");
        }
        if (this.privateKey == null) {
            throw new SMIMEException("Private Key not set");
        }
        if (this.certs == null) {
            throw new SMIMEException("Cert chain not set");
        }
        try {
            this.cmsSignature = new CMSSignature();
            this.cmsSignature.initSign(this.privateKey, this.certs, this.digestAlg);
            this.cmsSignature.setDataToBeSigned(new CMSTypedDataInputStream(this.getMessageStream(this.firstPart)), false);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)new SignedContent(this.cmsSignature), SIG_P7S);
            mimeBodyPart.addHeader(CONTENT_TRANSFER_ENCODING_HDR, B64);
            mimeBodyPart.addHeader(CONTENT_DISPOSITION_HDR, ATTACH_P7S);
            mimeBodyPart.addHeader(CONTENT_DESCRIPTION_HDR, "S/MIME Cryptographic Signature");
            this.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (Exception exception) {
            throw new SMIMEException("Signing error: " + exception.getMessage());
        }
    }

    public VerificationResult verify() throws SMIMEException {
        try {
            String string = null;
            String string2 = new ContentType(this.getContentType()).getParameterList().get(MICALG);
            if (string2 == null) {
                throw new SMIMEException("Unknown micalg");
            }
            if (string2.equals(SHA1)) {
                string = "SHA-1";
            } else if (string2.equals(MD5)) {
                string = "MD5";
            } else {
                throw new SMIMEException("Unknown micalg: " + string2);
            }
            this.cmsSignature = new CMSSignature();
            this.cmsSignature.initVerify(this.trusted, this.certStore);
            this.cmsSignature.setDataToBeVerified((InputStream)this.sigPart.getContent(), this.getMessageStream(this.firstPart));
            return this.cmsSignature.verify();
        }
        catch (Exception exception) {
            throw new SMIMEException("Verification error: nested exception is " + exception.toString());
        }
    }

    class CanonInputStream
    extends FilterInputStream {
        private byte[] buf = new byte[1];
        private boolean eof = false;
        private boolean availLF = false;
        private boolean discardLF = false;

        public CanonInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            if (this.eof) {
                return -1;
            }
            this.readOneByte(this.buf, 0);
            return this.eof ? -1 : this.buf[0] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.eof) {
                return -1;
            }
            int n3 = 0;
            while (n3 < n2) {
                this.readOneByte(byArray, n++);
                if (this.eof) break;
                ++n3;
            }
            return n3 == 0 ? -1 : n3;
        }

        private void readOneByte(byte[] byArray, int n) throws IOException {
            if (this.availLF) {
                byArray[n] = 10;
                this.availLF = false;
                return;
            }
            int n2 = this.in.read();
            if (this.discardLF && n2 == 10) {
                this.discardLF = false;
                n2 = this.in.read();
            }
            if (n2 == -1) {
                this.eof = true;
            } else if (n2 != 13 && n2 != 10) {
                byArray[n] = (byte)n2;
            } else if (n2 == 13) {
                byArray[n] = 13;
                this.availLF = true;
                this.discardLF = true;
            } else if (n2 == 10) {
                byArray[n] = 13;
                this.availLF = true;
            }
        }
    }
}

