/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.DHPublicKey;
import com.dstc.security.provider.Licensed;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

public class DHKeyPairGenerator
extends KeyPairGeneratorSpi
implements Licensed {
    private SecureRandom random;
    private int keyLength = 1024;
    private DHParameterSpec dhParams;
    private static final int MAX_KEY_LENGTH = 8192;
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        Serializable serializable;
        Object object;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.dhParams == null) {
            if (this.keyLength == 1024) {
                object = BigInteger.valueOf(2L);
                serializable = new BigInteger("179769313486231590770839156793787453197860296048756011706444423684197180216158519368947833795864925541502180565485980503646440548199239100050792877003355816639229553136239076508735759914822574862575007425302077447712589550957937778424442426617334727629299387668709205606050270810842907692932019128194467627007", 10);
                this.dhParams = new DHParameterSpec((BigInteger)serializable, (BigInteger)object, this.keyLength);
            } else {
                try {
                    object = AlgorithmParameterGenerator.getInstance("DH");
                    ((AlgorithmParameterGenerator)object).init(this.keyLength, this.random);
                    this.dhParams = (DHParameterSpec)((AlgorithmParameterGenerator)object).generateParameters().getParameterSpec(class$javax$crypto$spec$DHParameterSpec != null ? class$javax$crypto$spec$DHParameterSpec : (class$javax$crypto$spec$DHParameterSpec = DHKeyPairGenerator.class$("javax.crypto.spec.DHParameterSpec")));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("Internal error: " + noSuchAlgorithmException.getMessage());
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new RuntimeException("Internal error: " + invalidParameterSpecException.getMessage());
                }
            }
        }
        object = new BigInteger(this.keyLength, this.random);
        serializable = new DHPrivateKey((BigInteger)object, this.dhParams.getP(), this.dhParams.getG());
        BigInteger bigInteger = this.dhParams.getG().modPow((BigInteger)object, this.dhParams.getP());
        DHPublicKey dHPublicKey = new DHPublicKey(bigInteger, this.dhParams.getP(), this.dhParams.getG());
        return new KeyPair(dHPublicKey, (PrivateKey)serializable);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n > 8192) {
            throw new InvalidParameterException("key length too long. Max = 8192 bits");
        }
        this.random = secureRandom;
        this.keyLength = n;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not DH parameters");
        }
        int n = ((DHParameterSpec)algorithmParameterSpec).getL();
        if (n > 8192) {
            throw new InvalidParameterException("key length too long. Max = 8192 bits");
        }
        this.dhParams = (DHParameterSpec)algorithmParameterSpec;
        this.random = secureRandom;
    }
}

