/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.Licensed;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi
implements Licensed {
    protected final String alg;

    PBEKeyFactory(String string) {
        this.alg = string;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PBEKeySpec) {
            return new SecretKeySpec(this.toPasswordBytes(((PBEKeySpec)keySpec).getPassword()), this.alg);
        }
        throw new InvalidKeySpecException("Not a PBE key spec");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey.getAlgorithm().equals(this.alg)) {
            return new SecretKeySpec(secretKey.getEncoded(), this.alg);
        }
        throw new InvalidKeyException("Cannot translate this key");
    }

    protected abstract byte[] toPasswordBytes(char[] var1);
}

