/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.PrivateKeyInfo;
import com.dstc.security.provider.Licensed;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.util.Arrays;
import java.util.Iterator;

public class RSAPrivateCrtKey
implements java.security.interfaces.RSAPrivateCrtKey,
Licensed {
    private Asn1 asn1 = null;
    private int version = 0;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger p;
    private BigInteger q;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private static BigInteger one = BigInteger.valueOf(1L);

    protected RSAPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
    }

    protected RSAPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        this(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger3.mod(bigInteger4.subtract(one)), bigInteger3.mod(bigInteger5.subtract(one)), bigInteger5.modInverse(bigInteger4));
    }

    protected RSAPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.asn1 = new Sequence();
        this.asn1.add(new com.dstc.security.asn1.Integer(BigInteger.valueOf(this.version)));
        this.modulus = bigInteger;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger));
        this.publicExponent = bigInteger2;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger2));
        this.privateExponent = bigInteger3;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger3));
        this.p = bigInteger4;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger4));
        this.q = bigInteger5;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger5));
        this.primeExponentP = bigInteger6;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger6));
        this.primeExponentQ = bigInteger7;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger7));
        this.crtCoefficient = bigInteger8;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger8));
    }

    public RSAPrivateCrtKey(byte[] byArray) throws Asn1Exception, IOException {
        this.decode(Asn1.getAsn1(byArray));
    }

    void decode(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.version = ((com.dstc.security.asn1.Integer)iterator.next()).getInt();
        this.modulus = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
        this.publicExponent = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
        this.privateExponent = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
        this.p = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
        this.q = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
        this.primeExponentP = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
        this.primeExponentQ = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
        this.crtCoefficient = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            return Arrays.equals(this.getEncoded(), ((Key)object).getEncoded());
        }
        return false;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public byte[] getEncoded() {
        try {
            byte[] byArray = new PrivateKeyInfo(new AlgorithmId("1.2.840.113549.1.1.1", null), this.asn1.getEncoded()).getAsn1().getEncoded();
            return byArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getPrimeP() {
        return this.p;
    }

    public BigInteger getPrimeQ() {
        return this.q;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String toString() {
        byte[] byArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 7) {
            switch (n) {
                case 0: {
                    stringBuffer.append("Modulus: \n            ");
                    byArray = this.getModulus().toByteArray();
                    break;
                }
                case 1: {
                    stringBuffer.append("\nPrivate Exponent: \n            ");
                    byArray = this.getPrivateExponent().toByteArray();
                    break;
                }
                case 2: {
                    stringBuffer.append("\nPrime P: \n            ");
                    byArray = this.getPrimeP().toByteArray();
                    break;
                }
                case 3: {
                    stringBuffer.append("\nPrime Q: \n            ");
                    byArray = this.getPrimeQ().toByteArray();
                    break;
                }
                case 4: {
                    stringBuffer.append("\nPrime Exponent P: \n            ");
                    byArray = this.getPrimeExponentP().toByteArray();
                    break;
                }
                case 5: {
                    stringBuffer.append("\nPrime Exponent Q: \n            ");
                    byArray = this.getPrimeExponentQ().toByteArray();
                    break;
                }
                case 6: {
                    stringBuffer.append("\nCrt Coefficient: \n            ");
                    byArray = this.getCrtCoefficient().toByteArray();
                    break;
                }
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                if (n2 > 0 && n2 % 20 == 0) {
                    stringBuffer.append("\n            ");
                }
                if (byArray[n2] < 16 && byArray[n2] >= 0) {
                    stringBuffer.append("0" + Integer.toHexString(byArray[n2] & 0xFF) + " ");
                } else {
                    stringBuffer.append(String.valueOf(Integer.toHexString(byArray[n2] & 0xFF)) + " ");
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

