/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.cms.MessageDigestImpl;
import com.dstc.security.cms.Signer;
import com.dstc.security.cms.SigningTimeImpl;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

class DigestInputStream
extends FilterInputStream {
    private MessageDigest digest;
    private Signer signer;
    private Asn1 signedAtts;
    private boolean done = false;

    DigestInputStream(InputStream inputStream, MessageDigest messageDigest, Asn1 asn1, Signer signer) {
        super(inputStream);
        this.digest = messageDigest;
        this.signer = signer;
        this.signedAtts = asn1;
    }

    public void close() throws IOException {
        super.close();
    }

    private void digest() throws IOException {
        try {
            if (this.signedAtts != null) {
                this.signedAtts.add(new MessageDigestImpl(this.digest.digest()).getAsn1());
                this.signedAtts.add(new SigningTimeImpl().getAsn1());
                this.signer.computeSignature(this.signedAtts.getEncoded());
                this.signedAtts.setTagClass(128);
                this.signedAtts.setTagNumber(0);
            } else {
                this.signer.computeSignature(this.digest.digest());
            }
            this.done = true;
        }
        catch (Exception exception) {
            throw new IOException("Signing error: nested exception is " + exception.toString());
        }
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1 && !this.done) {
            this.digest();
        } else {
            this.digest.update((byte)(n & 0xFF));
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1 && !this.done) {
            this.digest();
        } else {
            this.digest.update(byArray, n, n + n3);
        }
        return n3;
    }
}

