/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.crypto;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.crypto.ContentKeyEncryption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class KeyWrap
implements ContentKeyEncryption {
    private static final byte[] IV_FIXED = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    protected SecretKey KEK = null;
    protected byte[] CEK = null;
    protected byte[] wrappedKey = null;
    protected Cipher cipher = null;
    protected String alg;
    protected SecureRandom rand = null;
    private MessageDigest sha = null;
    private byte[] ICV = new byte[8];
    private byte[] IV = new byte[8];
    private byte[] TEMP1 = null;

    protected KeyWrap(SecureRandom secureRandom) throws CMSException {
        try {
            this.rand = secureRandom;
            this.sha = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    private byte[] checksum() {
        byte[] byArray = this.sha.digest(this.CEK);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray) throws CMSException {
        return this.doUnwrap(byArray);
    }

    private byte[] doUnwrap(byte[] byArray) throws CMSException {
        try {
            this.wrappedKey = byArray;
            this.firstDecrypt();
            this.secondDecrypt();
            return this.postProcessKey(this.CEK);
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    private byte[] doWrap(byte[] byArray) throws CMSException {
        try {
            this.CEK = this.preProcessKey(byArray);
            this.firstEncrypt();
            this.secondEncrypt();
            return this.wrappedKey;
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    public byte[] encrypt(byte[] byArray) throws CMSException {
        return this.doWrap(byArray);
    }

    private void firstDecrypt() throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.cipher.init(2, (Key)this.KEK, new IvParameterSpec(IV_FIXED), this.rand);
        byte[] byArray = this.cipher.doFinal(this.wrappedKey);
        int n = byArray.length;
        int n2 = 0;
        while (n2 < this.IV.length) {
            this.IV[n2] = byArray[n - n2 - 1];
            ++n2;
        }
        this.TEMP1 = new byte[n - 8];
        int n3 = 0;
        while (n3 < this.TEMP1.length) {
            this.TEMP1[this.TEMP1.length - n3 - 1] = byArray[n3];
            ++n3;
        }
    }

    private void firstEncrypt() throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.rand.nextBytes(this.IV);
        this.cipher.init(1, (Key)this.KEK, new IvParameterSpec(this.IV), this.rand);
        this.ICV = this.checksum();
        byte[] byArray = new byte[this.ICV.length + this.CEK.length];
        System.arraycopy(this.CEK, 0, byArray, 0, this.CEK.length);
        System.arraycopy(this.ICV, 0, byArray, this.CEK.length, this.ICV.length);
        this.TEMP1 = this.cipher.doFinal(byArray);
    }

    protected abstract byte[] postProcessKey(byte[] var1);

    protected abstract byte[] preProcessKey(byte[] var1);

    private void secondDecrypt() throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.cipher.init(2, (Key)this.KEK, new IvParameterSpec(this.IV), this.rand);
        byte[] byArray = this.cipher.doFinal(this.TEMP1);
        this.CEK = new byte[byArray.length - 8];
        System.arraycopy(byArray, 0, this.CEK, 0, this.CEK.length);
        System.arraycopy(byArray, this.CEK.length, this.ICV, 0, 8);
        byte[] byArray2 = this.checksum();
        if (!Arrays.equals(byArray2, this.ICV)) {
            throw new InvalidKeyException("Bad checksum");
        }
    }

    private void secondEncrypt() throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        int n = this.TEMP1.length + this.IV.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < this.IV.length) {
            byArray[n - n2 - 1] = this.IV[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.TEMP1.length) {
            byArray[n3] = this.TEMP1[this.TEMP1.length - n3 - 1];
            ++n3;
        }
        this.cipher.init(1, (Key)this.KEK, new IvParameterSpec(IV_FIXED), this.rand);
        this.wrappedKey = this.cipher.doFinal(byArray);
    }

    public void setDecryptionKey(PrivateKey privateKey) {
        throw new UnsupportedOperationException("invalid for keywrap");
    }

    public void setEncryptionKey(PublicKey publicKey) {
        throw new UnsupportedOperationException("invalid for keywrap");
    }

    public void setKeyEncryptingKey(byte[] byArray) {
        this.KEK = new SecretKeySpec(byArray, this.alg);
    }
}

