/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.SignedData;
import com.dstc.security.smime.AddressMismatch;
import com.dstc.security.smime.SMIMEException;
import com.dstc.security.smime.SMIMESignedPart;
import com.dstc.security.smime.SMIMEUtil;
import com.dstc.security.smime.VerificationResult;
import com.dstc.security.smime.Warning;
import com.dstc.security.smime.handlers.MimeMultipartSigned;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMIMESignature {
    private static final int UNINITIALIZED = 0;
    private static final int SIGN_MODE = 1;
    private static final int VERIFY_MODE = 2;
    private MimeMessage msg;
    private int mode;
    private MimeMultipartSigned mp;
    private SMIMESignedPart sp;
    private String digestAlgName;
    private PrivateKey priv;
    private X509Certificate[] certs;
    private Vector trustedCerts;
    private Vector certStore;
    private boolean opaque;

    public SMIMESignature() {
        String string = System.getProperty("jcsi.smime.usemailcap");
        if (string == null || !string.equals("true")) {
            SMIMEUtil.setupMailcap();
        }
    }

    public void initSign(String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray, boolean bl) throws SMIMEException {
        this.priv = privateKey;
        this.certs = x509CertificateArray;
        this.digestAlgName = string;
        this.opaque = bl;
        this.mode = 1;
    }

    public void initVerify(Vector vector, Vector vector2) throws SMIMEException {
        this.trustedCerts = vector;
        this.certStore = vector2;
        this.mode = 2;
    }

    public void setMessage(MimeMessage mimeMessage) throws IOException, MessagingException, SMIMEException {
        if (this.mode == 0) {
            throw new SMIMEException("SMIMESignature not yet initialized");
        }
        this.msg = new MimeMessage(mimeMessage);
        if (this.mode != 1) {
            if (!SMIMEUtil.isSigned(mimeMessage)) {
                throw new SMIMEException("Not a signed message");
            }
            return;
        }
        if (this.msg.getContentType().startsWith("multipart")) {
            MimeMultipart mimeMultipart = (MimeMultipart)this.msg.getContent();
            if (!this.opaque) {
                this.mp = new MimeMultipartSigned((Multipart)mimeMultipart);
            } else {
                this.sp = new SMIMESignedPart((Multipart)mimeMultipart);
            }
        } else {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent(this.msg.getContent(), this.msg.getContentType());
            mimeBodyPart.setHeader("Content-Type", this.msg.getContentType());
            mimeBodyPart.setHeader("Content-Transfer-Encoding", this.msg.getEncoding());
            mimeBodyPart.setDisposition(this.msg.getDisposition());
            mimeBodyPart.setDescription(this.msg.getDescription());
            if (!this.opaque) {
                this.mp = new MimeMultipartSigned(mimeBodyPart);
            } else {
                this.sp = new SMIMESignedPart(mimeBodyPart);
            }
        }
        this.msg.setDisposition(null);
        this.msg.setDescription(null);
        this.msg.removeHeader("Content-Type");
        this.msg.removeHeader("Content-Transfer-Encoding");
    }

    public MimeMessage sign() throws SMIMEException, IOException, MessagingException {
        if (this.mode != 1) {
            throw new SMIMEException("Not initialized for signing");
        }
        if (this.msg == null) {
            throw new SMIMEException("Mime message not set");
        }
        if (!this.opaque) {
            this.mp.setDigestAlgorithm(this.digestAlgName);
            this.mp.setKeys(this.priv, this.certs);
            this.mp.sign();
            this.msg.setContent((Multipart)this.mp);
            this.msg.saveChanges();
            return this.msg;
        }
        this.sp.setDigestAlgorithm(this.digestAlgName);
        this.sp.setKeys(this.priv, this.certs);
        this.sp.sign();
        this.msg.setContent(this.sp.getContent(), "application/x-pkcs7-mime; smime-type=signed-data; name=\"smime.p7m\"");
        this.msg.setHeader("Content-Transfer-Encoding", "base64");
        this.msg.setHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
        this.msg.setHeader("Content-Description", "S/MIME Signed Message");
        this.msg.saveChanges();
        return this.msg;
    }

    public VerificationResult verify() throws SMIMEException, MessagingException, IOException {
        SignedData signedData = null;
        if (this.mode != 2) {
            throw new SMIMEException("Not initialized for verification");
        }
        if (this.msg == null) {
            throw new SMIMEException("Mime message not set");
        }
        com.dstc.security.cms.VerificationResult verificationResult = null;
        if (this.msg.getContent() instanceof MimeMultipartSigned) {
            this.mp = (MimeMultipartSigned)((Object)this.msg.getContent());
            if (this.certStore != null) {
                this.mp.setCertStore(this.certStore);
            }
            this.mp.setTrustedCAs(this.trustedCerts);
            verificationResult = this.mp.verify();
        } else {
            this.sp = new SMIMESignedPart();
            this.sp.setContent(this.msg.getContent(), this.msg.getContentType());
            if (this.certStore != null) {
                this.sp.setCertStore(this.certStore);
            }
            this.sp.setTrustedCAs(this.trustedCerts);
            verificationResult = this.sp.verify();
            this.msg.removeHeader("Content-Type");
            this.msg.removeHeader("Content-Transfer-Encoding");
            this.msg.removeHeader("Content-Description");
            this.msg.removeHeader("Content-Disposition");
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)verificationResult.getVerified());
        Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
        while (enumeration.hasMoreElements()) {
            this.msg.addHeaderLine((String)enumeration.nextElement());
        }
        this.msg.setContent(mimeBodyPart.getContent(), mimeBodyPart.getContentType());
        this.msg.saveChanges();
        try {
            signedData = verificationResult.getCMSSignedData();
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("Verification error: nested exception is " + cMSException.toString());
        }
        Warning[] warningArray = null;
        Address[] addressArray = this.msg.getFrom();
        String[] stringArray = null;
        String[] stringArray2 = SMIMEUtil.getEmailAddress(signedData.getSignerInfos()[0].getSignerCertificate());
        boolean bl = false;
        if (addressArray != null && addressArray.length > 0) {
            stringArray = new String[addressArray.length];
            int n = 0;
            while (n < addressArray.length) {
                stringArray[n] = addressArray[n].toString();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (stringArray[n].equals(stringArray2[n2])) {
                        bl = true;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        if (!bl) {
            warningArray = new Warning[]{new AddressMismatchImpl(stringArray, stringArray2)};
        }
        return new VerResult(this.msg, signedData, warningArray);
    }

    class VerResult
    implements VerificationResult {
        private MimeMessage msg;
        private SignedData sd;
        private Warning[] warns;

        VerResult(MimeMessage mimeMessage, SignedData signedData, Warning[] warningArray) {
            this.msg = mimeMessage;
            this.sd = signedData;
            this.warns = warningArray;
        }

        public SignedData getCMSSignedData() {
            return this.sd;
        }

        public MimeMessage getMessage() {
            return this.msg;
        }

        public Warning[] getWarnings() {
            return this.warns;
        }
    }

    class AddressMismatchImpl
    implements AddressMismatch {
        private String[] msgAdds;
        private String[] certAdds;

        AddressMismatchImpl(String[] stringArray, String[] stringArray2) {
            this.msgAdds = stringArray;
            this.certAdds = stringArray2;
        }

        public String[] getEmailAddressInCertificate() {
            return this.certAdds;
        }

        public String[] getEmailAddressInMessage() {
            return this.msgAdds;
        }

        public String getWarningString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer("Address mismatch:\n");
            if (this.msgAdds == null) {
                stringBuffer.append("\n  No sender address in message\n");
            } else {
                stringBuffer.append("  Sender address(es) in message:\n    ");
                n = 0;
                while (n < this.msgAdds.length) {
                    stringBuffer.append(this.msgAdds[n]).append(" ");
                    ++n;
                }
            }
            if (this.certAdds == null) {
                stringBuffer.append("\n  No email address in certificate\n");
            } else {
                stringBuffer.append("\n  Address(es) in certificate:\n    ");
                n = 0;
                while (n < this.certAdds.length) {
                    stringBuffer.append(this.certAdds[n]).append(" ");
                    ++n;
                }
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return this.getWarningString();
        }
    }
}

