/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.provider.Licensed;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Iterator;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Parameters
extends AlgorithmParametersSpi
implements Licensed {
    private static final String ASN1 = "ASN.1";
    private Asn1 asn1 = null;
    private int eKB;
    private int parameterVersion;
    private byte[] iv;
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void decode(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.parameterVersion = ((Integer)iterator.next()).getInt();
        if (this.parameterVersion == 160) {
            this.eKB = 40;
        } else if (this.parameterVersion == 120) {
            this.eKB = 64;
        } else if (this.parameterVersion == 58) {
            this.eKB = 128;
        }
        this.iv = ((OctetString)iterator.next()).getBytes();
    }

    private void encode() {
        this.asn1 = new Sequence();
        this.asn1.add(new Integer(this.parameterVersion));
        this.asn1.add(new OctetString(this.iv));
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string == null) {
            return this.engineGetEncoded();
        }
        if (string.equals(ASN1)) {
            return this.engineGetEncoded();
        }
        throw new RuntimeException("Unrecognized format " + string);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.equals(class$javax$crypto$spec$RC2ParameterSpec != null ? class$javax$crypto$spec$RC2ParameterSpec : (class$javax$crypto$spec$RC2ParameterSpec = RC2Parameters.class$("javax.crypto.spec.RC2ParameterSpec")))) {
            throw new InvalidParameterSpecException("Bad parameter specification " + clazz.getName());
        }
        return new RC2ParameterSpec(this.eKB, this.iv);
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException("Not an RC2 param spec");
        }
        this.eKB = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits();
        if (this.eKB == 40) {
            this.parameterVersion = 160;
        } else if (this.eKB == 64) {
            this.parameterVersion = 120;
        } else if (this.eKB == 128) {
            this.parameterVersion = 58;
        } else {
            throw new InvalidParameterSpecException("Bad parameter version");
        }
        this.iv = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
        this.encode();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.decode(Asn1.getAsn1(byArray));
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equals(ASN1)) {
            throw new RuntimeException("Format " + string + " unsupported");
        }
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer("RC2 Parameters");
        return stringBuffer.toString();
    }
}

