/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.BlockCipher;
import com.dstc.security.util.Bytes;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public final class RC5
extends BlockCipher {
    private int[] S;
    private int numRounds = 12;
    private int wordSize = 32;

    public RC5() {
        this.blockSize = this.wordSize / 4;
    }

    protected void decryptBlock(byte[] byArray, byte[] byArray2) {
        int[] nArray = Bytes.bytesLSBToInts(byArray, 0, this.blockSize);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = this.numRounds;
        while (n3 >= 1) {
            n2 -= this.S[2 * n3 + 1];
            n2 = n2 >>> (n & 0x1F) | n2 << 32 - (n & 0x1F);
            n2 ^= n;
            n -= this.S[2 * n3];
            n = n >>> (n2 & 0x1F) | n << 32 - (n2 & 0x1F);
            n ^= n2;
            --n3;
        }
        int[] nArray2 = new int[]{n - this.S[0], n2 - this.S[1]};
        Bytes.intsToBytesLSB(nArray2, byArray2);
    }

    protected void encryptBlock(byte[] byArray, byte[] byArray2) {
        int[] nArray = Bytes.bytesLSBToInts(byArray, 0, this.blockSize);
        int n = nArray[0] + this.S[0];
        int n2 = nArray[1] + this.S[1];
        int n3 = 1;
        while (n3 <= this.numRounds) {
            n ^= n2;
            n = (n << (n2 & 0x1F) | n >>> 32 - (n2 & 0x1F)) + this.S[2 * n3];
            n2 ^= n;
            n2 = (n2 << (n & 0x1F) | n2 >>> 32 - (n & 0x1F)) + this.S[2 * n3 + 1];
            ++n3;
        }
        int[] nArray2 = new int[]{n, n2};
        Bytes.intsToBytesLSB(nArray2, byArray2);
    }

    protected void initialize(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws IllegalStateException, InvalidKeyException {
        byte[] byArray;
        if (!key.getAlgorithm().equals("RC5")) {
            throw new InvalidKeyException("Not an RC5 Key");
        }
        if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            this.numRounds = ((RC5ParameterSpec)algorithmParameterSpec).getRounds();
            this.wordSize = ((RC5ParameterSpec)algorithmParameterSpec).getWordSize();
            this.blockSize = this.wordSize / 4;
            byArray = ((RC5ParameterSpec)algorithmParameterSpec).getIV();
            if (byArray != null) {
                this.IV = byArray;
            }
        }
        byArray = key.getEncoded();
        int[] nArray = Bytes.bytesLSBToInts(byArray, 0, byArray.length);
        this.S = new int[2 * this.numRounds + 2];
        this.S[0] = -1209970333;
        int n = 1;
        while (n < this.S.length) {
            this.S[n] = this.S[n - 1] + -1640531527;
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = nArray.length > this.S.length ? 3 * nArray.length : 3 * this.S.length;
        while (n6 > 0) {
            this.S[n2] = n4 = this.S[n2] + n4 + n5 << 3 | this.S[n2] + n4 + n5 >>> 29;
            nArray[n3] = n5 = nArray[n3] + n4 + n5 << (n4 + n5 & 0x1F) | nArray[n3] + n4 + n5 >>> 32 - (n4 + n5 & 0x1F);
            n2 = (n2 + 1) % this.S.length;
            n3 = (n3 + 1) % nArray.length;
            --n6;
        }
    }
}

