/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;

public class APOptions {
    public static final int USE_SESSION_KEY = 64;
    public static final int MUTUAL_REQUIRED = 32;
    private Asn1 asn1 = null;
    private byte[] contents;

    public APOptions() {
        this.contents = new byte[4];
    }

    APOptions(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        this.contents = ((BitString)asn1).getBytes();
    }

    void encode() {
        this.asn1 = new BitString(this.contents);
    }

    Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.encode();
        }
        return this.asn1;
    }

    public boolean mutualRequired() {
        return (this.contents[0] & 0x20) != 0;
    }

    public void reset() {
        int n = 0;
        while (n < 4) {
            this.contents[n] = 0;
            ++n;
        }
        this.asn1 = null;
    }

    public void setMutualRequired() {
        this.contents[0] = (byte)(this.contents[0] | 0x20);
        this.asn1 = null;
    }

    public void setUseSessionKey() {
        this.contents[0] = (byte)(this.contents[0] | 0x40);
        this.asn1 = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mutualRequired()) {
            stringBuffer.append("mutual-required ");
        }
        if (this.useSessionKey()) {
            stringBuffer.append("use-session-key");
        }
        return stringBuffer.toString();
    }

    public boolean useSessionKey() {
        return (this.contents[0] & 0x40) != 0;
    }
}

