/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.APOptions;
import com.dstc.security.kerberos.AuthDataElement;
import com.dstc.security.kerberos.AuthorizationDataElement;
import com.dstc.security.kerberos.Checksum;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.KDCReqImpl;
import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.KerberosCipher;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PaData;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.crypto.KerberosMac;
import com.dstc.security.kerberos.msg.KrbTGSReq;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.Vector;

final class KrbTGSReqImpl
extends KDCReqImpl
implements KrbTGSReq {
    private Credential cred;
    private int cksumType;
    private APOptions apOpts;
    private Vector authData;

    KrbTGSReqImpl(Asn1 asn1) throws KerberosException, Asn1Exception {
        super(asn1);
    }

    KrbTGSReqImpl(Credential credential, int n, APOptions aPOptions) {
        this(credential, n, aPOptions, null);
    }

    KrbTGSReqImpl(Credential credential, int n, APOptions aPOptions, AuthorizationDataElement[] authorizationDataElementArray) {
        super(12);
        this.cred = credential;
        this.cksumType = n;
        this.apOpts = aPOptions;
        this.authData = new Vector();
        if (authorizationDataElementArray != null) {
            int n2 = 0;
            while (n2 < authorizationDataElementArray.length) {
                this.authData.add(authorizationDataElementArray[n2]);
                ++n2;
            }
        }
    }

    void setAuthenticator() throws KerberosException {
        Object object;
        Object object2;
        Object object3;
        if (this.authData != null) {
            object3 = KerberosCipher.getInstance(this.cred.getSessionKey().keyType(), null);
            ((KerberosCipher)object3).initEncrypt(this.cred.getSessionKey(), new SecureRandom());
            try {
                Object object4;
                object2 = new Sequence();
                object = ((AbstractList)this.authData).iterator();
                while (object.hasNext()) {
                    object4 = (AuthorizationDataElement)object.next();
                    ((Asn1)object2).add(new AuthDataElement(object4.type(), object4.data()).getAsn1());
                }
                object4 = ((Asn1)object2).getEncoded();
                EncryptedDataImpl encryptedDataImpl = new EncryptedDataImpl(((KerberosCipher)object3).encrypt((byte[])object4));
                this.setEncAuthData(encryptedDataImpl);
            }
            catch (Asn1Exception asn1Exception) {
                throw new KerberosException(asn1Exception.getMessage());
            }
        }
        this.setKDCReqBody();
        object3 = KerberosMac.getInstance(this.cksumType);
        ((KerberosMac)object3).update(this.getEncodedBody());
        object2 = new Checksum(this.cksumType, ((KerberosMac)object3).doFinal());
        object = Kerberos.createApplicationRequest(this.cred, this.apOpts, -1, (Checksum)object2, null);
        this.addPaData(new PaDataTGSREQ(object.getEncoded()));
    }

    final class PaDataTGSREQ
    implements PaData {
        byte[] val;

        PaDataTGSREQ(byte[] byArray) {
            this.val = (byte[])byArray.clone();
        }

        public int type() {
            return 1;
        }

        public byte[] value() {
            return this.val;
        }
    }
}

