/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.KerberosException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PrincipalName {
    public static final int NT_UNKNOWN = 0;
    public static final int NT_PRINCIPAL = 1;
    public static final int NT_SRV_INST = 2;
    public static final int NT_SRV_HST = 3;
    public static final int NT_SRV_XHST = 4;
    public static final int NT_UID = 5;
    private Asn1 asn1;
    private int nameType;
    private Vector nameString;

    /*
     * Unable to fully structure code
     */
    public PrincipalName(int var1_1, String var2_2) {
        block1: {
            super();
            this.asn1 = null;
            this.nameString = null;
            this.nameType = var1_1;
            this.nameString = new Vector<E>();
            var3_3 = new StringTokenizer(var2_2, "/", false);
            if (var3_3.countTokens() != 1) ** GOTO lbl13
            this.nameString.add(var2_2);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.nameString.add(var3_3.nextToken());
lbl13:
                // 2 sources

                ** while (var3_3.hasMoreTokens())
            }
        }
    }

    public PrincipalName(int n, String[] stringArray) {
        this.asn1 = null;
        this.nameString = null;
        this.nameType = n;
        this.nameString = new Vector();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.nameString.add(stringArray[n2]);
            ++n2;
        }
    }

    PrincipalName(Asn1 asn1) throws Asn1Exception {
        this.asn1 = null;
        this.nameString = null;
        this.decode(asn1);
    }

    public PrincipalName(String string) {
        this(1, string);
    }

    public PrincipalName(byte[] byArray) throws KerberosException {
        this.asn1 = null;
        this.nameString = null;
        try {
            this.decode(Asn1.getAsn1(byArray));
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    private void decode(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.nameType = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.nameString = new Vector();
        Iterator iterator2 = ((Sequence)asn12.components().next()).components();
        while (iterator2.hasNext()) {
            this.nameString.add(((GeneralString)iterator2.next()).getString());
        }
    }

    private void encode() {
        this.asn1 = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(this.nameType));
        this.asn1.add(explicit);
        explicit = new Explicit(128, 1);
        Sequence sequence = new Sequence();
        Iterator iterator = ((AbstractList)this.nameString).iterator();
        while (iterator.hasNext()) {
            sequence.add(new GeneralString((String)iterator.next()));
        }
        explicit.add(sequence);
        this.asn1.add(explicit);
    }

    Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.encode();
        }
        return this.asn1;
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.getAsn1().getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public String[] nameComponents() {
        String[] stringArray = new String[this.nameString.size()];
        this.nameString.toArray(stringArray);
        return stringArray;
    }

    public int nameType() {
        return this.nameType;
    }

    public String toString() {
        Iterator iterator = ((AbstractList)this.nameString).iterator();
        StringBuffer stringBuffer = new StringBuffer((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append("/").append(iterator.next());
        }
        return stringBuffer.toString();
    }
}

