/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.keystore;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1DecodingException;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.certpath.CertPath;
import com.dstc.security.certpath.CertPathBuilder;
import com.dstc.security.certpath.X509CertSelector;
import com.dstc.security.common.X500Name;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.keystore.BagHandler;
import com.dstc.security.keymanage.pkcs12.AuthenticatedSafe;
import com.dstc.security.keymanage.pkcs12.SafeBag;
import com.dstc.security.keymanage.pkcs12.SafeContents;
import com.dstc.security.keymanage.pkcs12.bags.CertBag;
import com.dstc.security.keymanage.pkcs7.ContentInfo;
import com.dstc.security.keymanage.pkcs7.ContentInfoFactory;
import com.dstc.security.keymanage.util.PKCS12KeyFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.crypto.SecretKey;

public class NetscapeBagHandler
implements BagHandler {
    private Hashtable keys = new Hashtable();
    private Hashtable shroudedKeys = new Hashtable();
    private Hashtable certificates = new Hashtable();
    private Hashtable certsByKeyId = new Hashtable();
    private Hashtable certChainByKeyId = new Hashtable();
    private SecureRandom rnd;
    private char[] password;
    private Vector cloaked;

    public NetscapeBagHandler() {
        byte[] byArray = new byte[4];
        byArray[2] = 1;
        byArray[3] = 2;
        this.rnd = new SecureRandom(byArray);
        this.password = null;
        this.cloaked = new Vector();
    }

    public NetscapeBagHandler(AuthenticatedSafe authenticatedSafe) throws Asn1DecodingException, Asn1Exception {
        byte[] byArray = new byte[4];
        byArray[2] = 1;
        byArray[3] = 2;
        this.rnd = new SecureRandom(byArray);
        this.password = null;
        this.cloaked = new Vector();
        this.importBags(authenticatedSafe);
    }

    private String bytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(String.valueOf(Integer.toHexString(byArray[n] & 0xFF)) + " ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void contents(PrintStream printStream) {
        Enumeration enumeration = this.shroudedKeys.keys();
        printStream.println("ShroudedKeyBags:");
        while (enumeration.hasMoreElements()) {
            printStream.println("\t" + (String)enumeration.nextElement());
        }
        Enumeration enumeration2 = this.certificates.keys();
        printStream.println("CertBags:");
        while (enumeration2.hasMoreElements()) {
            printStream.println("\t" + (String)enumeration2.nextElement());
        }
        printStream.flush();
    }

    public AuthenticatedSafe export() {
        return this.export(null, null);
    }

    public AuthenticatedSafe export(String string, char[] cArray) {
        ContentInfo contentInfo;
        Object object;
        Object object2;
        Collection collection = null;
        SafeBag[] safeBagArray = null;
        collection = this.shroudedKeys.values();
        safeBagArray = new SafeBag[collection.size()];
        safeBagArray = collection.toArray(safeBagArray);
        SafeContents safeContents = new SafeContents(safeBagArray);
        collection = this.certificates.values();
        safeBagArray = new SafeBag[collection.size()];
        safeBagArray = collection.toArray(safeBagArray);
        SafeContents safeContents2 = new SafeContents(safeBagArray);
        Enumeration enumeration = this.certChainByKeyId.elements();
        Vector<SafeBag> vector = new Vector<SafeBag>();
        while (enumeration.hasMoreElements()) {
            object2 = (SafeBag[])enumeration.nextElement();
            int n = 0;
            while (n < ((SafeBag[])object2).length) {
                vector.add(object2[n]);
                ++n;
            }
        }
        safeBagArray = new SafeBag[vector.size()];
        safeBagArray = vector.toArray(safeBagArray);
        object2 = new SafeContents(safeBagArray);
        AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe();
        if (cArray == null || string == null) {
            authenticatedSafe.add(safeContents);
            authenticatedSafe.add(safeContents2);
            authenticatedSafe.add((SafeContents)object2);
        } else {
            try {
                object = safeContents.getAsn1();
                contentInfo = ContentInfoFactory.createContentInfo((Asn1)object);
                ContentInfo contentInfo2 = ContentInfoFactory.encrypt(contentInfo, string, cArray);
                authenticatedSafe.add(contentInfo2);
                Asn1 asn1 = safeContents2.getAsn1();
                ContentInfo contentInfo3 = ContentInfoFactory.createContentInfo(asn1);
                ContentInfo contentInfo4 = ContentInfoFactory.encrypt(contentInfo3, string, cArray);
                authenticatedSafe.add(contentInfo4);
            }
            catch (Exception exception) {
                throw new RuntimeException("encryption error");
            }
        }
        object = ((AbstractList)this.cloaked).iterator();
        while (object.hasNext()) {
            contentInfo = (ContentInfo)object.next();
            authenticatedSafe.add(contentInfo);
        }
        return authenticatedSafe;
    }

    public SafeBag[] getAllBags() {
        int n = this.shroudedKeys.size() + this.certificates.size();
        SafeBag[] safeBagArray = new SafeBag[n];
        int n2 = 0;
        Enumeration enumeration = this.shroudedKeys.elements();
        while (enumeration.hasMoreElements()) {
            safeBagArray[n2] = (SafeBag)enumeration.nextElement();
            ++n2;
        }
        enumeration = this.certificates.elements();
        while (enumeration.hasMoreElements()) {
            safeBagArray[n2++] = (SafeBag)enumeration.nextElement();
        }
        return safeBagArray;
    }

    public String[] getAllFriendlyNames() {
        Enumeration enumeration = this.shroudedKeys.keys();
        Enumeration enumeration2 = this.certificates.keys();
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            try {
                String string = (String)enumeration2.nextElement();
                if (this.getBag(string).getLocalKeyId() != null) continue;
                vector.add(string);
            }
            catch (IOException iOException) {}
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        Iterator iterator = ((AbstractList)vector).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            ++n2;
        }
        return stringArray;
    }

    public SafeBag getBag(String string) {
        SafeBag safeBag = (SafeBag)this.shroudedKeys.get(string);
        if (safeBag == null) {
            safeBag = (SafeBag)this.certificates.get(string);
        }
        return safeBag;
    }

    public SafeBag getBag(byte[] byArray) {
        return (SafeBag)this.certsByKeyId.get(this.bytesToString(byArray));
    }

    public SafeBag[] getBags(String string) {
        SafeBag safeBag = (SafeBag)this.shroudedKeys.get(string);
        SafeBag safeBag2 = (SafeBag)this.certificates.get(string);
        int n = 0;
        if (safeBag != null) {
            ++n;
        }
        if (safeBag2 != null) {
            ++n;
        }
        SafeBag[] safeBagArray = new SafeBag[n];
        int n2 = 0;
        if (safeBag != null) {
            safeBagArray[n2] = safeBag;
            ++n2;
        }
        if (safeBag2 != null) {
            safeBagArray[n2] = safeBag2;
            ++n2;
        }
        return safeBagArray;
    }

    public X509Certificate[] getChain(String string) {
        SafeBag[] safeBagArray = (SafeBag[])this.certChainByKeyId.get(string);
        if (safeBagArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[safeBagArray.length];
        int n = 0;
        while (n < x509CertificateArray.length) {
            x509CertificateArray[n] = (X509Certificate)((CertBag)safeBagArray[n].getBag()).getCertificate();
            ++n;
        }
        return x509CertificateArray;
    }

    private String getSKBAlias(byte[] byArray) {
        String string = null;
        byte[] byArray2 = null;
        Enumeration enumeration = this.shroudedKeys.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            try {
                byArray2 = ((SafeBag)this.shroudedKeys.get(string)).getLocalKeyId();
            }
            catch (IOException iOException) {
                return null;
            }
            if (!Arrays.equals(byArray, byArray2)) continue;
            return string;
        }
        return null;
    }

    public void importBags(AuthenticatedSafe authenticatedSafe) throws Asn1DecodingException, Asn1Exception {
        Object object;
        Object object2;
        Object object3;
        SafeBag[] safeBagArray;
        ContentInfo[] contentInfoArray = authenticatedSafe.getContents();
        SafeContents safeContents = null;
        SecretKey[] secretKeyArray = null;
        if (this.password != null) {
            secretKeyArray = new SecretKey[]{PKCS12KeyFactory.createPBEKey(this.password)};
        }
        int n = 0;
        while (n < contentInfoArray.length) {
            try {
                safeBagArray = (SafeBag[])ContentInfoFactory.recurse(contentInfoArray[n], secretKeyArray, null);
                object3 = Asn1.getAsn1((byte[])safeBagArray);
                safeContents = new SafeContents((Asn1)object3);
            }
            catch (Exception exception) {
                Debug.log(2, "NetscapeBagHandler.importBags()", "Unable to decrypt ContentInfo");
                Debug.log(1, "NetscapeBagHandler.importBags()", exception.toString());
                this.cloaked.add(contentInfoArray[n]);
            }
            if (safeContents != null) {
                safeBagArray = safeContents.getAllSafeBags();
                this.storeBags(safeBagArray);
                safeContents = null;
            }
            ++n;
        }
        safeBagArray = new Vector();
        object3 = (Hashtable)this.certificates.clone();
        Enumeration<Object> enumeration = this.certificates.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (CertBag)((SafeBag)this.certificates.get(object2)).getBag();
            safeBagArray.add((X509Certificate)((CertBag)object).getCertificate());
        }
        enumeration = this.certsByKeyId.elements();
        object2 = null;
        object = new X509CertSelector();
        CertPathBuilder certPathBuilder = new CertPathBuilder();
        CertPath certPath = null;
        certPathBuilder.setTrustedCerts((Vector)safeBagArray);
        while (enumeration.hasMoreElements()) {
            SafeBag safeBag = (SafeBag)enumeration.nextElement();
            object2 = (X509Certificate)((CertBag)safeBag.getBag()).getCertificate();
            String string = null;
            try {
                string = this.getSKBAlias(safeBag.getLocalKeyId());
            }
            catch (IOException iOException) {
                continue;
            }
            if (string == null) continue;
            ((X509CertSelector)object).setIssuerDN(((X509Certificate)object2).getIssuerDN().getName());
            ((X509CertSelector)object).setSerialNumber(((X509Certificate)object2).getSerialNumber());
            try {
                certPath = certPathBuilder.build((Collection)safeBagArray, (X509CertSelector)object);
                int n2 = certPath.getPath().length;
                SafeBag[] safeBagArray2 = new SafeBag[n2];
                int n3 = 0;
                while (n3 < n2) {
                    X509Certificate x509Certificate = certPath.getPath()[n3];
                    SafeBag safeBag2 = null;
                    String string2 = null;
                    Enumeration enumeration2 = this.certificates.keys();
                    while (enumeration2.hasMoreElements()) {
                        String string3 = (String)enumeration2.nextElement();
                        SafeBag safeBag3 = (SafeBag)this.certificates.get(string3);
                        X509Certificate x509Certificate2 = (X509Certificate)((CertBag)safeBag3.getBag()).getCertificate();
                        if (!x509Certificate.getSerialNumber().equals(x509Certificate2.getSerialNumber()) || !X500Name.equals(x509Certificate.getIssuerDN(), x509Certificate2.getIssuerDN())) continue;
                        if (safeBag3.getFNAttribute() == null) {
                            safeBagArray2[n3] = safeBag3;
                            ((Hashtable)object3).remove(string3);
                            break;
                        }
                        safeBag2 = safeBag3;
                        string2 = string3;
                    }
                    if (safeBagArray2[n3] == null) {
                        safeBagArray2[n3] = safeBag2;
                        ((Hashtable)object3).remove(string2);
                        safeBagArray2[n3].removeFN();
                    }
                    ++n3;
                }
                this.certChainByKeyId.put(string, safeBagArray2);
                this.certificates = object3;
            }
            catch (Exception exception) {
                throw new RuntimeException("Certpath building error");
            }
        }
    }

    public void removeBags(String string) {
        this.shroudedKeys.remove(string);
        this.certificates.remove(string);
        this.certChainByKeyId.remove(string);
    }

    public void removeBags(String string, String string2) {
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public int size() {
        return this.shroudedKeys.size() + this.certificates.size();
    }

    public void storeBag(SafeBag safeBag) {
        block4: {
            String string;
            block6: {
                block5: {
                    string = safeBag.getFriendlyName();
                    if (!safeBag.getBagId().equals("1.2.840.113549.1.12.10.1.2")) break block5;
                    this.shroudedKeys.put(safeBag.getFriendlyName(), safeBag);
                    break block4;
                }
                if (!safeBag.getBagId().equals("1.2.840.113549.1.12.10.1.1")) break block6;
                this.keys.put(safeBag.getFriendlyName(), safeBag);
                break block4;
            }
            if (!safeBag.getBagId().equals("1.2.840.113549.1.12.10.1.3")) break block4;
            try {
                byte[] byArray = safeBag.getLocalKeyId();
                if (byArray != null) {
                    this.certsByKeyId.put(this.bytesToString(byArray), safeBag);
                }
                if (!this.certificates.containsKey(string)) {
                    this.certificates.put(safeBag.getFriendlyName(), safeBag);
                    break block4;
                }
                byte[] byArray2 = new byte[20];
                this.rnd.nextBytes(byArray2);
                this.certificates.put(String.valueOf(string) + this.bytesToString(byArray2), safeBag);
            }
            catch (IOException iOException) {}
        }
    }

    public void storeBags(SafeBag[] safeBagArray) {
        int n = 0;
        while (n < safeBagArray.length) {
            this.storeBag(safeBagArray[n]);
            ++n;
        }
    }

    public void storeChain(String string, Vector vector) {
        SafeBag[] safeBagArray = new SafeBag[vector.size()];
        int n = 0;
        while (n < safeBagArray.length) {
            safeBagArray[n] = (SafeBag)vector.elementAt(n);
            ++n;
        }
        this.certChainByKeyId.put(string, safeBagArray);
    }
}

