/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs7;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.pkcs7.AlgorithmId;
import java.util.Iterator;

public class DigestInfo {
    private Asn1 asn1 = null;
    private AlgorithmId digestAlgorithm = null;
    private byte[] digest = null;

    public DigestInfo(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        try {
            Asn1 asn12 = (Asn1)iterator.next();
            this.digestAlgorithm = new AlgorithmId(asn12);
            OctetString octetString = (OctetString)iterator.next();
            this.digest = octetString.getBytes();
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid AlgorithmId ASN.1");
        }
    }

    public DigestInfo(AlgorithmId algorithmId, byte[] byArray) {
        this.digestAlgorithm = algorithmId;
        this.digest = byArray;
        this.asn1 = new Sequence();
        this.asn1.add(algorithmId.getAsn1());
        this.asn1.add(new OctetString(byArray));
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public AlgorithmId getDigestAlgorithm() {
        return this.digestAlgorithm;
    }
}

